/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import com.sun.mail.util.BASE64DecoderStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.ReplacementFor;
import oracle.bpm.components.ComponentRuntimeException;
import oracle.bpm.components.MailAttachment;
import oracle.bpm.components.MailNotAvailableException;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

@Component(module="Fuego.Net", runsOnClient=false)
public class Mail
implements Serializable,
Cloneable {
    private MailAttachment[] attachments;
    private String[] bcc;
    private String[] cc;
    private byte[] contentBytesMessage;
    private String contentType = "text/plain; charset=UTF-8";
    private Map embeddedBodyParts;
    private transient Flags flags;
    private String from = "";
    private Map headers;
    private List loadingErrors = new ArrayList();
    private transient Message mailMessage;
    private String message = "";
    private String[] recipient;
    private String subject = "(no subject)";
    private static final String[] STRING = new String[0];
    private static final MailAttachment[] MAIL_ATTACHMENT = new MailAttachment[0];
    @Exclude
    public static final String MAIL_KEY = "oracle.bpm.components.Mail.mail";
    static final long serialCheck = -1587423890923661031L;
    static final long serialVersionUID = 2177788825194772305L;

    @Hidden
    public Mail() {
        this.embeddedBodyParts = new HashMap();
    }

    @Exclude
    public Mail(Message mailMessage) throws MailNotAvailableException {
        this.mailMessage = mailMessage;
        this.embeddedBodyParts = new HashMap();
        try {
            Address[] ccRecipients;
            this.flags = mailMessage.getFlags();
            this.headers = new HashMap();
            Address[] fromArray = mailMessage.getFrom();
            this.from = fromArray != null ? fromArray[0].toString() : "";
            this.subject = mailMessage.getSubject();
            Address[] toRecipients = mailMessage.getRecipients(Message.RecipientType.TO);
            if (toRecipients != null) {
                this.recipient = new String[toRecipients.length];
                for (int i = 0; i < this.recipient.length; ++i) {
                    this.recipient[i] = toRecipients[i].toString();
                }
            } else {
                this.recipient = STRING;
            }
            if ((ccRecipients = mailMessage.getRecipients(Message.RecipientType.CC)) != null) {
                this.cc = new String[ccRecipients.length];
                for (int i = 0; i < this.cc.length; ++i) {
                    this.cc[i] = ccRecipients[i].toString();
                }
            } else {
                this.cc = STRING;
            }
            this.bcc = STRING;
            Enumeration e = mailMessage.getAllHeaders();
            while (e.hasMoreElements()) {
                Header headerElement = (Header)e.nextElement();
                this.headers.put(headerElement.getName(), headerElement.getValue());
            }
        }
        catch (MessagingException e) {
            LibMsg.COULD_NOT_READ_MAIL_HEADERS(e, this.getMessageId()).logWarning();
            Log.logWarning(e);
            throw MailNotAvailableException.cannotReadMessageHeaders(e, this.getMessageId());
        }
        this.loadMessageContent();
    }

    @Hidden
    Mail(String from, String subject, String content) {
        this.subject = subject;
        this.from = from;
        this.message = content;
        this.embeddedBodyParts = new HashMap();
        this.attachments = MAIL_ATTACHMENT;
    }

    Mail(String from, String message, String subject, String[] recipient) {
        this.from = from;
        this.message = message;
        this.subject = subject;
        this.recipient = recipient;
    }

    Mail(String from, String message, String subject, String recipient) {
        this(from, message, subject, new String[]{recipient});
    }

    public static Mail openFrom(byte[] contents) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(contents);
            MimeMessage mimeMessage = new MimeMessage(null, (InputStream)inputStream);
            Mail mail = new Mail((Message)mimeMessage);
            return mail;
        }
        catch (MessagingException e) {
            throw MailNotAvailableException.cantReadContent_exception(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static Mail openFrom(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
            MimeMessage mimeMessage = new MimeMessage(null, (InputStream)inputStream);
            Mail mail = new Mail((Message)mimeMessage);
            return mail;
        }
        catch (MessagingException e) {
            throw MailNotAvailableException.cantReadContent_exception(e);
        }
        catch (FileNotFoundException e) {
            throw MailNotAvailableException.cantReadContent_exception(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Exclude
    public void addEmbeddedBodyPart(String id, DataHandler dh) {
        this.embeddedBodyParts.put(id, dh);
    }

    @Exclude
    public boolean canSend() {
        return Mail.getOutgoingServer() != null;
    }

    public boolean containsUserFlag(String flag) {
        return this.flags != null && this.flags.contains(flag);
    }

    public void copyTo(String folder) {
        if (this.mailMessage == null) {
            throw new Exception(LibMsg.MAIL_WITHOUT_JAVAMAIL_MESSAGE);
        }
        try {
            Folder sourceFolder = this.mailMessage.getFolder();
            if (sourceFolder == null) {
                throw new Exception(LibMsg.MAIL_WITHOUT_FOLDER);
            }
            Store store = sourceFolder.getStore();
            Folder destinationFolder = store.getFolder(folder);
            sourceFolder.copyMessages(new Message[]{this.mailMessage}, destinationFolder);
        }
        catch (MessagingException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    public MailAttachment[] getAttachments() {
        return this.attachments;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    public byte[] getBytes() {
        if (this.mailMessage == null) {
            return this.getMessage().getBytes();
        }
        try {
            if (this.contentBytesMessage == null && this.mailMessage instanceof MimeMessage) {
                InputStream rawInputStream = ((MimeMessage)this.mailMessage).getRawInputStream();
                this.contentBytesMessage = StreamUtils.readBytes(rawInputStream);
            }
        }
        catch (IOException e) {
            throw MailNotAvailableException.cantReadContent_exception(e);
        }
        catch (MessagingException e) {
            throw MailNotAvailableException.cantReadContent_exception(e);
        }
        return this.contentBytesMessage;
    }

    public String[] getCc() {
        return this.cc;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Exclude
    public Map getEmbeddedBodyPart() {
        return this.embeddedBodyParts;
    }

    public String getFrom() {
        return this.from;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public List getLoadingErrors() {
        return this.loadingErrors;
    }

    @Exclude
    public Message getMailMessage() {
        return this.mailMessage;
    }

    public String getMessage() {
        return this.message;
    }

    @ReplacementFor(value="to")
    public String[] getRecipients() {
        return this.recipient;
    }

    public String getSubject() {
        return this.subject;
    }

    public String[] getUserFlags() {
        return this.flags == null ? STRING : this.flags.getUserFlags();
    }

    public boolean hasLoadingErrors() {
        return this.loadingErrors.size() > 0;
    }

    public boolean isAnswered() {
        return this.flagsContains(Flags.Flag.ANSWERED);
    }

    public boolean isDeleted() {
        return this.flagsContains(Flags.Flag.DELETED);
    }

    public boolean isFlagged() {
        return this.flagsContains(Flags.Flag.FLAGGED);
    }

    public boolean isRecent() {
        return this.flagsContains(Flags.Flag.RECENT);
    }

    public boolean isSeen() {
        return this.flagsContains(Flags.Flag.SEEN);
    }

    public void moveTo(String folder) {
        this.copyTo(folder);
        this.setDeleted(true);
    }

    public void send() {
        this.send(Mail.getOutgoingServer());
    }

    @Deprecated
    @Hidden
    public void send(String to) {
        this.setRecipient(to);
        this.send(Mail.getOutgoingServer());
    }

    @Deprecated
    @Hidden
    public void send(String[] to) {
        this.setRecipients(to);
        this.send(Mail.getOutgoingServer());
    }

    public void setAnswered(boolean value) {
        this.setFlag(Flags.Flag.ANSWERED, value);
    }

    public void setAttachments(MailAttachment[] att) {
        if (att == null) {
            att = MAIL_ATTACHMENT;
        }
        this.attachments = att;
    }

    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    public void setCc(String[] cc) {
        this.cc = cc;
    }

    public void setContentType(String t) {
        this.contentType = t;
    }

    public void setDeleted(boolean value) {
        this.setFlag(Flags.Flag.DELETED, value);
    }

    public void setFlagged(boolean value) {
        this.setFlag(Flags.Flag.FLAGGED, value);
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    public void setRecipient(String recipient) {
        this.recipient = new String[]{recipient};
    }

    public void setRecipients(String[] recipient) {
        this.recipient = recipient;
    }

    public void setSeen(boolean value) {
        this.setFlag(Flags.Flag.SEEN, value);
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setUserFlag(String flag, boolean set) {
        if (this.mailMessage != null) {
            try {
                Flags f = new Flags(flag);
                this.mailMessage.setFlags(f, set);
            }
            catch (MessagingException e) {
                throw MailNotAvailableException.msg_exception(e);
            }
        }
    }

    @Exclude
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("from    : ").append(this.from).append("\n");
        buffer.append("to      : ");
        if (this.recipient != null) {
            for (String aRecipient : this.recipient) {
                buffer.append(aRecipient).append(" ");
            }
        }
        buffer.append("\nsubject : ").append(this.subject).append("\n");
        buffer.append("Message:  (").append(this.message).append(")\n");
        int length = this.attachments != null ? this.attachments.length : 0;
        for (int i = 0; i < length; ++i) {
            buffer.append("Attachment ").append(i);
            buffer.append(this.attachments[i].toString());
        }
        return buffer.toString();
    }

    public byte[] getEMLBytes() {
        String header = this.getHeaderString();
        try {
            byte[] headerBytes = header.getBytes("UTF-8");
            byte[] messageBytes = this.getBytes();
            byte[] emlBytes = new byte[headerBytes.length + messageBytes.length];
            System.arraycopy(headerBytes, 0, emlBytes, 0, headerBytes.length);
            System.arraycopy(messageBytes, 0, emlBytes, headerBytes.length, messageBytes.length);
            return emlBytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    public String getHeaderString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getHeaders() != null) {
            for (Object o : this.getHeaders().keySet()) {
                String key = (String)o;
                stringBuffer.append(key);
                stringBuffer.append(": ");
                stringBuffer.append(this.getHeaders().get(key));
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static OutgoingServer getOutgoingServer() {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        if (ctx == null) {
            throw new IllegalStateException(LibMsg.MUST_RUN_SERVER_SIDE.getString());
        }
        OutgoingServer iface = (OutgoingServer)ctx.getProperty(MAIL_KEY);
        if (iface == null) {
            throw new IllegalStateException("server interface not initialized");
        }
        return iface;
    }

    private void addLoadingError(Throwable t) {
        this.loadingErrors.add(t);
    }

    private boolean flagsContains(Flags.Flag flag) {
        return this.flags != null && this.flags.contains(flag);
    }

    private String getMessageId() {
        try {
            return this.mailMessage.getHeader("Message-ID")[0];
        }
        catch (MessagingException e) {
            return null;
        }
    }

    private void loadMessageContent() {
        String message = null;
        MailAttachment[] mailAttachments = null;
        try {
            try {
                this.setContentType(this.mailMessage.getContentType());
            }
            catch (NullPointerException npe) {
                throw new MessagingException(npe.getMessage());
            }
            Object content = this.mailMessage.getContent();
            if (content instanceof String) {
                if (this.mailMessage.getDisposition() != null && "attachment".equals(this.mailMessage.getDisposition())) {
                    mailAttachments = this.loadMessageAsAttachment();
                } else {
                    message = (String)content;
                }
            } else if (content instanceof MimeMessage) {
                mailAttachments = this.loadMessageAsAttachment();
            } else if (content instanceof MimeMultipart) {
                int containsText = 0;
                List allParts = this.getPartsFrom((Part)this.mailMessage);
                for (int i = 0; i < allParts.size(); ++i) {
                    if (!((Part)allParts.get(i)).isMimeType("text/plain") || containsText != 0) continue;
                    message = (String)((Part)allParts.get(i)).getContent();
                    containsText = 1;
                }
                mailAttachments = this.loadAttachments(content, containsText);
            } else if (content instanceof BASE64DecoderStream) {
                BASE64DecoderStream b64ds = (BASE64DecoderStream)content;
                mailAttachments = new MailAttachment[1];
                String contentType = this.mailMessage.getContentType();
                int indexOf = contentType.indexOf(";");
                String type = indexOf > -1 ? contentType.substring(0, indexOf) : contentType;
                mailAttachments[0] = new MailAttachment(StreamUtils.readBytes((InputStream)b64ds), type, this.mailMessage.getFileName());
            }
        }
        catch (IOException e) {
            LibMsg.COULD_NOT_READ_MAIL_CONTENT(e, this.getMessageId()).logWarning();
            Log.logWarning(e);
            message = null;
            mailAttachments = null;
            this.addLoadingError(e);
        }
        catch (MessagingException e) {
            LibMsg.COULD_NOT_READ_MAIL_CONTENT((java.lang.Exception)((Object)e), this.getMessageId()).logWarning();
            Log.logWarning(e);
            message = null;
            mailAttachments = null;
            this.addLoadingError(e);
        }
        this.setMessage(message);
        this.setAttachments(mailAttachments);
    }

    private MailAttachment[] loadMessageAsAttachment() throws IOException, MessagingException {
        InputStream is = this.mailMessage.getInputStream();
        String type = this.mailMessage.getContentType();
        String fileName = this.mailMessage.getFileName();
        MailAttachment[] mailAttachments = new MailAttachment[]{new MailAttachment(StreamUtils.readBytes(is), type, fileName)};
        return mailAttachments;
    }

    private MailAttachment[] loadAttachments(Object content, int containsText) throws MessagingException, IOException {
        MimeMultipart mimeMultipart = (MimeMultipart)content;
        MailAttachment[] mailAttachments = new MailAttachment[mimeMultipart.getCount() - containsText];
        for (int i = 0; i < mailAttachments.length; ++i) {
            String fileName;
            String type;
            BodyPart bodyPart = mimeMultipart.getBodyPart(i + containsText);
            Object bodyPartContent = bodyPart.getContent();
            if (bodyPartContent instanceof BASE64DecoderStream) {
                BASE64DecoderStream b64ds = (BASE64DecoderStream)bodyPartContent;
                type = bodyPart.getContentType();
                fileName = bodyPart.getFileName();
                mailAttachments[i] = new MailAttachment(StreamUtils.readBytes((InputStream)b64ds), type, fileName);
                continue;
            }
            InputStream is = bodyPart.getInputStream();
            type = bodyPart.getContentType();
            fileName = bodyPart.getFileName();
            mailAttachments[i] = new MailAttachment(StreamUtils.readBytes(is), type, fileName);
        }
        return mailAttachments;
    }

    private List getPartsFrom(Part part) throws MessagingException, IOException {
        ArrayList<Part> answer = new ArrayList<Part>();
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                answer.addAll(this.getPartsFrom((Part)mp.getBodyPart(i)));
            }
        } else if (part.isMimeType("message/rfc822")) {
            answer.addAll(this.getPartsFrom((Part)part.getContent()));
        }
        answer.add(part);
        return answer;
    }

    private void outputParts(Part part, int index) throws MessagingException, IOException {
        String nestLevel = "-";
        for (int i = 0; i < index; ++i) {
            nestLevel = nestLevel + "-";
        }
        System.out.println(nestLevel + "> NEW PART");
        if (part.isMimeType("multipart/*")) {
            System.out.println(nestLevel + "> [" + index + "]" + part.getContentType());
            System.out.println(nestLevel + "> [" + index + "]" + part.getDisposition());
            System.out.println(nestLevel + "> [" + index + "]" + " is multipart/*");
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            System.out.println(nestLevel + "> [" + index + "]" + " Parts count is " + count);
            for (int i = 0; i < count; ++i) {
                this.outputParts((Part)mp.getBodyPart(i), index + 1);
            }
        } else if (part.isMimeType("message/rfc822")) {
            System.out.println(nestLevel + "> [" + index + "]" + part.getContentType());
            System.out.println(nestLevel + "> [" + index + "]" + part.getDisposition());
            System.out.println(nestLevel + "> [" + index + "]" + " is message/rfc822");
            this.outputParts((Part)part.getContent(), index + 1);
        } else {
            System.out.println(nestLevel + "> " + part.getContentType());
            System.out.println(nestLevel + "> " + part.getDisposition());
        }
    }

    private void setFlag(Flags.Flag flag, boolean value) {
        if (this.mailMessage == null) {
            return;
        }
        try {
            this.mailMessage.setFlag(flag, value);
        }
        catch (MessagingException e) {
            throw MailNotAvailableException.msg_exception(e);
        }
    }

    private void send(OutgoingServer outgoingServer) {
        block4: {
            if (outgoingServer == null) {
                throw new Exception(LibMsg.INV_MAIL_SERVER);
            }
            if (this.message == null) {
                throw new Exception(LibMsg.EMPTY_MESSAGE);
            }
            try {
                outgoingServer.send((Mail)this.clone());
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("Cannot happen " + e.getMessage()));
            }
        }
    }

    @Exclude
    public static class Exception
    extends ComponentRuntimeException {
        static final long serialVersionUID = -4735440444399522746L;
        static final long serialCheck = 7390215979317049533L;

        public Exception(Msg id) {
            super(id);
        }
    }

    @Exclude
    public static interface OutgoingServer {
        public void send(Mail var1);
    }
}

