/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.component.metadata.Type;
import oracle.bpm.components.ComponentRuntimeException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;
import oracle.bpm.util.ObjectWatch;

@Component(module="Fuego.Util")
public class Event {
    private Info info;
    private static final Map<String, Info> events = new HashMap<String, Info>();

    public Event() {
        this(String.valueOf(System.currentTimeMillis()) + (int)(Math.random() * 2.147483647E9));
    }

    public Event(String id) {
        this.setInfoFromId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        Info info;
        Info info2 = info = this.getInfo();
        synchronized (info2) {
            return info.getDescription();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDescription(String description) {
        Info info;
        Info info2 = info = this.getInfo();
        synchronized (info2) {
            info.setDescription(description);
        }
    }

    public void trigger() {
        this.trigger(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(Map arguments) {
        Info info;
        Info info2 = info = this.getInfo();
        synchronized (info2) {
            info.setArguments(arguments);
            if (info.getWaiterThread() != null) {
                info.setNotifyed(true);
                info.notify();
                Map<String, Info> map = events;
                synchronized (map) {
                    events.remove(info.getId());
                }
            } else {
                info.setConsumed(false);
            }
        }
    }

    @Method(result="arguments")
    @Type(value="Any[String]")
    public Map waitFor() throws Exception {
        return this.waitFor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Method(result="arguments")
    @Type(value="Any[String]")
    public Map waitFor(Interval timeout) throws Exception {
        Info info = this.getInfo();
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        if (ctx != null && ctx.getProperty("wsCall") != null) {
            ctx.partialCommit();
        }
        Info info2 = info;
        synchronized (info2) {
            if (info.getWaiterThread() != null) {
                throw new IllegalStateException("There is another thread waiting for this event.");
            }
            if (!info.isConsumed()) {
                info.setConsumed(true);
                Map<String, Info> map = events;
                synchronized (map) {
                    events.remove(info.getId());
                }
                return info.consumeArguments();
            }
            info.setWaiterThread(Thread.currentThread());
            try {
                if (timeout != null) {
                    info.wait(timeout.getMilliSeconds());
                } else {
                    info.wait();
                }
                if (!info.isNotifyed()) {
                    throw new ComponentRuntimeException(LibMsg.WAIT_FOR(timeout));
                }
                info.setConsumed(true);
            }
            finally {
                info.setWaiterThread(null);
            }
            return info.consumeArguments();
        }
    }

    Info getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInfoFromId(String id) {
        Map<String, Info> map = events;
        synchronized (map) {
            Info info = events.get(id);
            if (info == null) {
                info = new Info(id);
                events.put(id, info);
            }
            this.info = info;
        }
    }

    static {
        ObjectWatch.register("events", "events", "events", events);
    }

    static class Info {
        private Map arguments;
        private boolean consumed = true;
        private String description;
        private String id;
        private boolean notifyed = false;
        private Thread waiterThread = null;

        Info(String id) {
            this.id = id;
        }

        Map consumeArguments() {
            Map arguments = this.getArguments();
            this.setArguments(null);
            return arguments;
        }

        Map getArguments() {
            return this.arguments;
        }

        String getDescription() {
            return this.description;
        }

        String getId() {
            return this.id;
        }

        Thread getWaiterThread() {
            return this.waiterThread;
        }

        boolean isConsumed() {
            return this.consumed;
        }

        boolean isNotifyed() {
            return this.notifyed;
        }

        void setArguments(Map arguments) {
            this.arguments = arguments;
        }

        void setConsumed(boolean consumed) {
            this.consumed = consumed;
        }

        void setDescription(String description) {
            this.description = description;
        }

        void setId(String id) {
            this.id = id;
        }

        void setNotifyed(boolean notifyed) {
            this.notifyed = notifyed;
        }

        void setWaiterThread(Thread waiterThread) {
            this.waiterThread = waiterThread;
        }
    }
}

