/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.io.Serializable;
import oracle.bpm.component.QueueInfo;
import oracle.bpm.lang.Time;
import oracle.bpm.util.ArrayUtils;

public class PoolInfo
implements Serializable {
    private int busy;
    private int[] constraints;
    private int[] counters;
    private int free;
    private QueueInfo queueInfo;
    private int rogueCounter;
    private int rogueLimit;
    private int size;
    private long timeStamp;
    private int unused;
    static final long serialVersionUID = -7838898211573179651L;
    static final long serialCheck = 117073109079332222L;

    PoolInfo(int size, int free, int busy, int unused, int[] constraints, int[] counters, QueueInfo queueInfo, int rogueLimit, int rogueCounter) {
        this.size = size;
        this.free = free;
        this.busy = busy;
        this.unused = unused;
        this.constraints = constraints;
        this.counters = counters;
        this.queueInfo = queueInfo;
        this.rogueLimit = rogueLimit;
        this.rogueCounter = rogueCounter;
        this.timeStamp = System.currentTimeMillis();
    }

    public int getBusy() {
        return this.busy;
    }

    public int[] getConstraints() {
        return this.constraints;
    }

    public int[] getCounters() {
        return this.counters;
    }

    public int getFree() {
        return this.free;
    }

    public QueueInfo getQueueInfo() {
        return this.queueInfo;
    }

    public int getRogueCounter() {
        return this.rogueCounter;
    }

    public int getRogueLimit() {
        return this.rogueLimit;
    }

    public int getSize() {
        return this.size;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getUnused() {
        return this.unused;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PoolInfo[size=");
        sb.append(this.size);
        sb.append(", free=");
        sb.append(this.free);
        sb.append(", busy=");
        sb.append(this.busy);
        sb.append(", unused=");
        sb.append(this.unused);
        sb.append(", ts=");
        sb.append(Time.valueOf(this.timeStamp * 1000L));
        sb.append(", constraints=");
        sb.append(ArrayUtils.toString(this.constraints));
        sb.append(", counters=");
        sb.append(ArrayUtils.toString(this.counters));
        sb.append(", queue=");
        sb.append(this.queueInfo);
        sb.append(", rogueLimit=");
        sb.append(this.rogueLimit);
        sb.append(", rogueCounter=");
        sb.append(this.rogueCounter);
        sb.append("]");
        return sb.toString();
    }
}

