/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import fuego.papi.Invocation;
import java.lang.reflect.InvocationTargetException;
import oracle.bpm.component.Message;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;

public class InvocationImpl
implements Invocation {
    private Object[] inputArgs;
    private Message message;
    private Object[] originalArguments;
    private Object[] outputArgs;
    private String signature;
    private boolean synchronous;
    private Invokeable target;

    InvocationImpl(Object[] originalArguments, Message message, Invokeable target, String signature, boolean synchronous, Object[] inputArgs, Object[] outputArgs) {
        this.originalArguments = originalArguments;
        this.message = message;
        this.target = target;
        this.signature = signature;
        this.synchronous = synchronous;
        this.inputArgs = inputArgs;
        this.outputArgs = outputArgs;
    }

    @Override
    public Object[] getInputArgs() {
        return this.inputArgs;
    }

    @Override
    public boolean isOutOfOrder() {
        return this.message.hasTarget();
    }

    @Override
    public Object[] getOutputArgs() {
        return this.outputArgs;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public boolean isSynchronous() {
        return this.synchronous;
    }

    @Override
    public Object doInvoke(Object[] args) throws ComponentExecutionException {
        try {
            return this.target.invoke(this.signature, args);
        }
        catch (InvocationTargetException e) {
            throw new ComponentExecutionException(e, this.target.getTarget().getClass().getName(), JavaClass.getMethodNameFromSignature(this.signature));
        }
    }

    @Override
    public Object[] doPostInvoke(Object[] methodArgs, Object retVal) {
        int length = this.outputArgs == null ? 0 : this.outputArgs.length;
        Object[] output = new Object[length + 1];
        output[0] = retVal;
        if (this.outputArgs != null) {
            for (int i = 0; i < length; ++i) {
                String sig = (String)this.outputArgs[i];
                if ("#R".equals(sig)) {
                    output[i + 1] = retVal;
                    continue;
                }
                if (sig.charAt(0) == '#') {
                    int index = Integer.parseInt(sig.substring(1));
                    output[i + 1] = methodArgs[index];
                    continue;
                }
                output[i + 1] = this.target.getAttributeValue(sig);
            }
        }
        if (this.message.isRelay()) {
            output = this.message.buildContinuationArgs(this.originalArguments, output);
        }
        return output;
    }

    @Override
    public Object[] doPreInvoke() {
        int argno;
        String signature;
        int i;
        if (this.inputArgs == null) {
            return null;
        }
        int max = -1;
        int length = this.inputArgs.length;
        for (i = 0; i < length; i += 2) {
            signature = (String)this.inputArgs[i];
            if (signature.charAt(0) != '#' || (argno = Integer.parseInt(signature.substring(1))) <= max) continue;
            max = argno;
        }
        if (this.outputArgs != null) {
            for (i = 0; i < this.outputArgs.length; ++i) {
                signature = (String)this.outputArgs[i];
                if (signature.charAt(0) != '#' || signature.equals("#R") || (argno = Integer.parseInt(signature.substring(1))) <= max) continue;
                max = argno;
            }
        }
        Object[] result = max == -1 ? null : new Object[max + 1];
        for (int i2 = 0; i2 < this.inputArgs.length; i2 += 2) {
            String signature2 = (String)this.inputArgs[i2];
            Object value = this.inputArgs[i2 + 1];
            if (signature2.charAt(0) == '#') {
                assert (result != null) : "illegal ordinal argument signature found: " + signature2;
                result[Integer.parseInt((String)signature2.substring((int)1))] = value;
                continue;
            }
            this.target.setAttributeValue(signature2, value);
        }
        return result;
    }

    @Override
    public Object[] invoke() throws Exception {
        Object[] args = this.doPreInvoke();
        Object retval = this.doInvoke(args);
        return this.doPostInvoke(args, retval);
    }
}

