/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import oracle.bpm.component.InstantiatorFactoryExtension;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.log.Log;

public abstract class Instantiator {
    public abstract Invokeable instantiate(String var1, String var2) throws ClassNotFoundException, ComponentExecutionException;

    public static Instantiator forName(String componentType, String configName) {
        InstantiatorFactoryExtension factory = Instantiator.getFactoryExtension(componentType);
        assert (factory != null) : "Could not get factory for '" + componentType + "', (config: " + configName + ')';
        return factory.getInstantiator(configName);
    }

    public static void initWatches() {
    }

    public static void setInitializer(String componentType, Initializer init) {
        InstantiatorFactoryExtension factory = Instantiator.getFactoryExtension(componentType);
        factory.setInitializer(init);
    }

    public Invokeable instantiate(String qualifiedName, String classname, String constructor, Object[] args) throws ClassNotFoundException, ComponentExecutionException {
        return this.instantiate(qualifiedName, classname);
    }

    protected static Object[] processInputArguments(Object[] inputArgs) {
        if (inputArgs == null) {
            return null;
        }
        int max = -1;
        int length = inputArgs.length;
        for (int i = 0; i < length; i += 2) {
            int argno;
            String signature = (String)inputArgs[i];
            if (signature.charAt(0) != '#' || (argno = Integer.parseInt(signature.substring(1))) <= max) continue;
            max = argno;
        }
        Object[] result = max == -1 ? null : new Object[max + 1];
        for (int i = 0; i < inputArgs.length; i += 2) {
            String signature = (String)inputArgs[i];
            Object value = inputArgs[i + 1];
            if (signature.charAt(0) != '#' || result == null) continue;
            result[Integer.parseInt((String)signature.substring((int)1))] = value;
        }
        return result;
    }

    protected static void processInputAttributes(Invokeable instance, Object[] inputArgs) {
        if (inputArgs != null) {
            for (int i = 0; i < inputArgs.length; i += 2) {
                String signature = (String)inputArgs[i];
                Object value = inputArgs[i + 1];
                if (signature.charAt(0) == '#') continue;
                instance.setAttributeValue(signature, value);
            }
        }
    }

    private static InstantiatorFactoryExtension getFactoryExtension(String componentType) {
        try {
            return InstantiatorFactoryExtension.getExtensionByType(componentType);
        }
        catch (InstantiationException e) {
            Log.logFatal(e);
            e.printStackTrace();
            return null;
        }
    }

    public static class Initializer {
        public Invokeable initialize(String componentName, Invokeable obj) {
            return obj;
        }

        public String replaceClass(String classname) {
            return classname;
        }
    }
}

