/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import fuego.papi.Invocation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import oracle.bpm.component.Batch;
import oracle.bpm.component.CustomExecution;
import oracle.bpm.component.ExecutionThread;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.Message;
import oracle.bpm.component.Principal;
import oracle.bpm.component.Proxy;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.log.Log;

public class ExecutorClient {
    private HashMap createdObjects;
    private Integer lastCtxId;
    private Invokeable lastObject;
    private int nextObjectId;
    private Proxy proxy;

    public ExecutorClient(Proxy proxy) {
        this.proxy = proxy;
        this.createdObjects = new HashMap();
    }

    public static Principal createPrincipal(Invokeable target) {
        return ExecutorClient.createPrincipal(target, 0);
    }

    public static Principal createPrincipal(final Invokeable target, final int group) {
        return new Principal(){

            @Override
            public Batch processBatch(Batch requests) {
                return ExecutionThread.doProcessBatch(this, requests, group);
            }

            @Override
            public Object getInfo() {
                return null;
            }

            @Override
            public Invokeable getTarget() {
                return target;
            }

            @Override
            public ExecutionThreadContext createContext() {
                ExecutionThreadContext executionContext = new ExecutionThreadContext(this, true);
                return executionContext;
            }
        };
    }

    public CustomExecution customInvoke(String signature, Object[] args) {
        return this.sendRequest(Message.createInvoke(signature, args), signature, args);
    }

    public Object invoke(String signature, Object[] args) throws Exception {
        CustomExecution ce = this.customInvoke(signature, args);
        Invocation inv = ce.next();
        while (inv != null) {
            try {
                ce.setInvocationResult(inv.invoke());
            }
            catch (Exception e) {
                ce.setException(e);
            }
            inv = ce.next();
        }
        return ce.getReturnValue();
    }

    static Object[] invoke(Invokeable target, String name, boolean synchronous, Object[] inputArgs, Object[] outputArgs) throws Exception {
        try {
            int length = outputArgs == null ? 1 : outputArgs.length + 1;
            Object[] results = !synchronous ? null : new Object[length];
            Object ret = target.invoke(name, synchronous, inputArgs, outputArgs);
            if (results != null) {
                results[0] = ret;
                if (outputArgs != null) {
                    System.arraycopy(outputArgs, 0, results, 1, length - 1);
                }
            }
            return results;
        }
        catch (InvocationTargetException e) {
            throw new ComponentExecutionException(e, target.getTarget().getClass().getName(), JavaClass.getMethodNameFromSignature(name));
        }
        catch (Exception e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            throw e;
        }
    }

    void destroyObjects(Integer sessionId) {
        Iterator it = this.createdObjects.values().iterator();
        while (it.hasNext()) {
            Object[] entry = (Object[])it.next();
            if (!sessionId.equals(entry[0])) continue;
            it.remove();
        }
    }

    Batch dispatch(Batch requests) {
        return this.proxy.processBatch(requests);
    }

    Invokeable findObject(Integer objectId, Integer sessionId) {
        if (objectId == null) {
            if (sessionId.equals(this.lastCtxId)) {
                Invokeable result = this.lastObject;
                this.lastObject = null;
                this.lastCtxId = null;
                return result;
            }
            return null;
        }
        return (Invokeable)((Object[])this.createdObjects.get(objectId))[1];
    }

    Object processReference(Integer sessionId, Object object) {
        return object;
    }

    Object[] processReferences(Integer sessionId, Object[] results) {
        if (results == null) {
            return null;
        }
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.processReference(sessionId, results[i]);
        }
        return results;
    }

    Integer registerObject(Integer sessionId, Invokeable invokeable) {
        int i = ++this.nextObjectId;
        Integer result = i;
        this.createdObjects.put(result, new Object[]{sessionId, invokeable});
        this.lastCtxId = sessionId;
        this.lastObject = invokeable;
        return result;
    }

    private CustomExecution sendRequest(Message request, String signature, Object[] args) {
        boolean condition;
        Batch requests = new Batch(request);
        Batch responses = this.proxy.processBatch(requests);
        boolean bl = condition = !responses.isEmpty();
        assert (condition) : "Responses must not be empty";
        Integer sessionId = responses.get().getId();
        return new CustomExecution(this, sessionId, responses, signature, args);
    }
}

