/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.component.Batch;
import oracle.bpm.component.CILSecurityContext;
import oracle.bpm.component.ClientRemoteComponent;
import oracle.bpm.component.ContextEvent;
import oracle.bpm.component.ContextListener;
import oracle.bpm.component.ExecutionContextInfo;
import oracle.bpm.component.ExecutionContextState;
import oracle.bpm.component.ExecutionThread;
import oracle.bpm.component.Message;
import oracle.bpm.component.Principal;
import oracle.bpm.component.Request;
import oracle.bpm.component.Response;
import oracle.bpm.component.Task;
import oracle.bpm.lang.AbortedException;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.lang.TimeoutException;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.Destroyable;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;
import oracle.bpm.util.ObjectWatch;

public class ExecutionThreadContext {
    protected final Object abortLock = new Object();
    private volatile boolean aborted = false;
    private volatile int abortStatus = 1;
    private boolean createDefaultCtx;
    private long creation;
    private List<WeakReference<Destroyable>> destroyableObjects;
    private ExceptionFactory exceptionFactory;
    private volatile long expiration = 0L;
    private Integer id;
    private final Set<ContextListener> listeners;
    private Principal parent;
    private int priority;
    private Request request = null;
    private final Object requestLock = new Object();
    private Batch responses;
    private final Object responsesLock = new Object();
    private volatile int state = 0;
    private ExecutionThread thread;
    private LowResolutionTimer timer;
    public static final Integer NEW;
    private static final Object nextIdLock;
    private static int nextId;
    public static final int STARTED = 0;
    public static final int RUNNING = 1;
    public static final int WAITING_CLIENT = 2;
    public static final int RELAY = 3;
    public static final int FINISHED = 4;
    public static final int ABORTING = 5;
    public static final int ABORTED = 6;
    public static final int TIMED_OUT = 7;
    private static final Map<Integer, ExecutionThreadContext> runningContexts;
    private static final long ABORT_PHASE_TIMEOUT = 500L;
    private static final int NOMINAL = 1;
    private static final int PHASE_ONE = 2;
    private static final int PHASE_TWO = 3;
    private static final int PHASE_THREE = 4;
    private static final int HUNG = 5;

    public ExecutionThreadContext(Principal parent) {
        this(parent, false);
    }

    public ExecutionThreadContext(Principal parent, boolean createDefaultCtx) {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof ExecutionThread)) {
            throw new IllegalThreadStateException("The current thread must be an execution thread");
        }
        this.creation = System.currentTimeMillis();
        this.id = ExecutionThreadContext.nextId();
        this.parent = parent;
        this.thread = (ExecutionThread)thread;
        this.priority = thread.getPriority();
        this.listeners = new TreeSet<ContextListener>();
        runningContexts.put(this.id, this);
        this.createDefaultCtx = createDefaultCtx;
        if (createDefaultCtx) {
            ExecutionContextAccessor.setContext(new ExecutionContext(){
                private Map<String, Object> properties = new HashMap<String, Object>();
                private boolean clientAvailable = true;

                @Override
                public boolean isExecutingTransition() {
                    return false;
                }

                public Object getProperty(String key) {
                    return this.properties.get(key);
                }

                @Override
                public void putProperty(String key, Object value) {
                    if (value == null) {
                        this.properties.remove(key);
                    } else {
                        this.properties.put(key, value);
                    }
                }

                @Override
                public long getTimeToLive() {
                    return ExecutionThreadContext.this.getTimeToLive();
                }

                @Override
                public void setTimeout(long millis) {
                    ExecutionThreadContext.this.setTimeout(millis);
                }

                @Override
                public void registerForCleanUp(Destroyable victim) {
                    ExecutionThreadContext.this.registerForCleanUp(victim);
                }

                @Override
                public boolean isClientAvailable() {
                    return this.clientAvailable;
                }

                @Override
                public String getCurrentParticipantId() {
                    return null;
                }

                @Override
                public boolean enableClient(boolean enabled) {
                    boolean wasEnabled = this.clientAvailable;
                    this.clientAvailable = enabled;
                    return wasEnabled;
                }

                @Override
                public String getCurrentParticipantName() {
                    return null;
                }

                @Override
                public Invokeable instantiateRemoteComponent(String componentType, String configName, String qualifiedName, String classname, String constructor, Object[] args) throws ClassNotFoundException, ComponentExecutionException {
                    return ExecutionThreadContext.this.instantiateRemoteComponent(componentType, configName, qualifiedName, classname, constructor, args);
                }

                @Override
                public String translateConfiguration(String configName) {
                    return configName;
                }

                @Override
                public String translateConfiguration(int processIn, String configName) {
                    return configName;
                }

                @Override
                public void partialCommit() throws Exception {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ExecutionContextInfo> getRuntimeInfo() {
        ArrayList<ExecutionContextInfo> info = new ArrayList<ExecutionContextInfo>();
        ExecutionThreadContext currentSession = ExecutionThreadContext.current();
        long now = System.currentTimeMillis();
        Map<Integer, ExecutionThreadContext> map = runningContexts;
        synchronized (map) {
            Iterator<ExecutionThreadContext> it = runningContexts.values().iterator();
            while (it.hasNext()) {
                ExecutionThreadContext session = it.next();
                if (session.equals(currentSession)) continue;
                if ((session.state == 6 || session.state == 7) && now - session.creation > 0x6DDD00L) {
                    it.remove();
                }
                info.add(session.getInfo());
            }
        }
        return info;
    }

    public static ExecutionThreadContext current() {
        Thread t = Thread.currentThread();
        if (t instanceof ExecutionThread) {
            return ((ExecutionThread)t).getContext();
        }
        return null;
    }

    public static Object invokeMethod(String methodName, Class[] argTypes, Object target, Object[] args, Interval timeout) throws ComponentExecutionException, IllegalThreadStateException {
        assert (timeout != null);
        return ExecutionThreadContext.current().invokeMethod(methodName, argTypes, target, args, timeout.getTotalMicroseconds() / 1000L);
    }

    public void setExceptionFactory(ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    public Integer getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContextInfo getInfo() {
        boolean aborting;
        Object object = this.abortLock;
        synchronized (object) {
            aborting = this.abortStatus != 1;
        }
        ExecutionContextState state = ExecutionContextState.forId(aborting ? 5 : this.state);
        Object principalInfo = this.parent == null ? null : this.parent.getInfo();
        int id = this.id == null ? -1 : this.id;
        return new ExecutionContextInfo(id, this.creation, this.expiration, state, principalInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToLive() {
        Object object = this.abortLock;
        synchronized (object) {
            if (this.abortStatus != 1) {
                throw new AbortedException();
            }
        }
        long now = System.currentTimeMillis();
        if (this.expiration != 0L && now >= this.expiration) {
            this.fireEvent(ContextEvent.TIMEOUT_EXPIRED);
            throw new TimeoutException();
        }
        return this.expiration == 0L ? 0L : this.expiration - now;
    }

    public void setTimeout(long millis) {
        this.expiration = millis > 0L ? System.currentTimeMillis() + millis : 0L;
        this.fireEvent(ContextEvent.TIMEOUT_CHANGED(millis));
    }

    public boolean isWithinCILExecution() {
        return this.thread.getSecurityContext().isWithinCILExecution();
    }

    public Invokeable instantiateRemoteComponent(String componentType, String configName, String qualifiedName, String classname, String constructor, Object[] args) throws ClassNotFoundException, ComponentExecutionException {
        return new ClientRemoteComponent(componentType, configName, qualifiedName, classname, constructor, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHung() {
        Object object = this.abortLock;
        synchronized (object) {
            return this.abortStatus == 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.abortLock;
        synchronized (object) {
            if (this.abortStatus != 1) {
                throw new IllegalStateException("Current context is already being aborted");
            }
            CILSecurityContext securityContext = this.thread.getSecurityContext();
            if (securityContext != null && !securityContext.isWithinCILExecution()) {
                if (this.state == 2) {
                    this.thread.interrupt();
                }
                this.aborted = true;
                return;
            }
            while (!this.aborted && this.abortStatus != 5) {
                switch (this.abortStatus) {
                    case 1: {
                        this.abortStatus = 2;
                        this.expire();
                        this.waitForAbort();
                        break;
                    }
                    case 2: {
                        this.abortStatus = 3;
                        this.thread.interrupt();
                        this.waitForAbort();
                        break;
                    }
                    case 3: {
                        this.abortStatus = 4;
                        if (securityContext == null) break;
                        securityContext.setInFullAccessDenial(true);
                        this.waitForAbort();
                        break;
                    }
                    case 4: {
                        this.abortStatus = 5;
                        this.priority = this.thread.getPriority();
                        this.thread.setPriority(1);
                        this.thread.remove();
                        Batch batch = new Batch(Message.createException(this.id, this.createException(6)));
                        this.thread.sendResult(batch);
                        this.fireEvent(ContextEvent.HUNG);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ContextListener listener) {
        Set<ContextListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    public boolean inRelay() {
        return this.state == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ContextListener listener) {
        Set<ContextListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runForAbort(Task task) throws Exception {
        Object object = this.abortLock;
        synchronized (object) {
            return task.run();
        }
    }

    public String toString() {
        return "Id = " + this.id;
    }

    protected Exception createException(int state) {
        Exception ex = null;
        if (this.exceptionFactory != null) {
            ex = this.exceptionFactory.createException(state);
        }
        if (ex == null) {
            ex = state == 7 ? new TimeoutException() : new AbortedException();
        }
        return ex;
    }

    /*
     * Exception decompiling
     */
    protected Object invokeMethod(String methodName, Class[] argTypes, Object target, Object[] args, long timeout) throws ComponentExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void initWatches() {
        ObjectWatch.register("Execution Framework", "context", "Running Contexts", runningContexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void abortAll() {
        ExecutionThreadContext[] running;
        Map<Integer, ExecutionThreadContext> map = runningContexts;
        synchronized (map) {
            Collection<ExecutionThreadContext> values = runningContexts.values();
            running = values.toArray(new ExecutionThreadContext[values.size()]);
        }
        for (int i = 0; i < running.length; ++i) {
            ExecutionThreadContext context = running[i];
            context.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void wakeup(Request request) {
        Integer id = request.getId();
        ExecutionThreadContext ctx = runningContexts.get(id);
        if (ctx == null) {
            Log.logWarning(LibMsg.UNKNOWN_CONTEXT(id, request.getBatch()));
            ExecutionThreadContext.sendException(request, new IllegalStateException("unknown context id: " + id + ", possibly the execution timed-out or has been aborted"));
            return;
        }
        int state = ctx.state;
        switch (state) {
            case 6: 
            case 7: {
                runningContexts.remove(id);
                ExecutionThreadContext.sendException(request, ctx.createException(state));
                break;
            }
            case 2: {
                Object object = ctx.requestLock;
                synchronized (object) {
                    ctx.request = request;
                    ctx.requestLock.notify();
                    break;
                }
            }
            default: {
                ExecutionThreadContext.sendException(request, new IllegalStateException("current state is " + state));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispose() {
        this.fireEvent(ContextEvent.DISPOSE);
        this.cleanUp();
        this.finishAbort();
        if (this.state == 6 || this.state == 7) {
            this.timer = new LowResolutionTimer(300);
            this.timer.add(new LowResolutionTimerListener(){

                @Override
                public void timerFired(LowResolutionTimer timer) {
                    runningContexts.remove(ExecutionThreadContext.this.id);
                }
            });
            this.timer.start();
        } else {
            this.setState(4);
            runningContexts.remove(this.id);
        }
        this.fireEvent(ContextEvent.AFTER_DISPOSE);
        Set<ContextListener> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
    }

    void setRunning() {
        this.setState(1);
    }

    Invokeable getTarget() {
        return this.parent.getTarget();
    }

    void setWaitingClient() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponse(Message response) {
        if (response.isRelay()) {
            this.setState(3);
        }
        Object object = this.responsesLock;
        synchronized (object) {
            if (this.responses == null) {
                this.responses = new Batch();
            }
            while (response != null) {
                this.responses.add(response);
                response = response.getNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Batch clearResponses() {
        Batch result;
        Object object = this.responsesLock;
        synchronized (object) {
            result = this.responses;
            this.responses = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Batch doClientInvoke() {
        Batch result;
        assert (Thread.currentThread() == this.thread);
        try {
            if (!this.inRelay()) {
                this.fireEvent(ContextEvent.BEFORE_CLIENT_EXECUTION);
                this.setWaitingClient();
            }
            this.thread.sendResult(this.clearResponses());
            result = null;
            if (!this.inRelay()) {
                Request req = this.waitResponse();
                this.setRunning();
                result = req.getBatch();
            }
        }
        finally {
            if (!this.inRelay()) {
                this.fireEvent(ContextEvent.AFTER_CLIENT_EXECUTION);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextId() {
        Object object = nextIdLock;
        synchronized (object) {
            return nextId++;
        }
    }

    private static void sendException(Request req, Throwable t) {
        Batch result = new Batch();
        result.add(Message.createException(req.getId(), t));
        Response response = req.getResponse();
        response.put(result);
    }

    private void setState(int state) {
        if (this.thread != Thread.currentThread()) {
            throw new IllegalThreadStateException("State changes can only be made from the this context's thread");
        }
        this.state = state;
    }

    private void cleanUp() {
        if (this.destroyableObjects != null && !this.destroyableObjects.isEmpty()) {
            Iterator<WeakReference<Destroyable>> it = this.destroyableObjects.iterator();
            while (it.hasNext()) {
                WeakReference<Destroyable> ref = it.next();
                Destroyable victim = (Destroyable)ref.get();
                if (victim != null) {
                    try {
                        victim.destroy();
                    }
                    catch (Throwable t) {
                        Log.logWarning(t);
                    }
                }
                it.remove();
            }
        }
        if (this.createDefaultCtx) {
            ExecutionContextAccessor.setContext(null);
        }
    }

    private void expire() {
        this.expiration = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAbort() {
        Object object = this.abortLock;
        synchronized (object) {
            this.aborted = true;
            if (this.abortStatus != 1) {
                CILSecurityContext securityContext = this.thread.getSecurityContext();
                if (securityContext != null) {
                    securityContext.setInFullAccessDenial(false);
                }
                this.thread.setPriority(this.priority);
                Thread.interrupted();
                if (this.abortStatus != 5) {
                    this.abortStatus = 1;
                }
                this.abortLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ContextEvent event) {
        Set<ContextListener> set = this.listeners;
        synchronized (set) {
            int size = this.listeners.size();
            if (size == 0) {
                return;
            }
            for (ContextListener listener : this.listeners) {
                try {
                    listener.processEvent(this, event);
                }
                catch (Exception e) {
                    Log.logWarning(LibMsg.EXCEPTION_DISPATCHING_EVENT(ExceptionFormatter.fullTechLevel(e)));
                }
            }
        }
    }

    private void registerForCleanUp(Destroyable obj) {
        if (this.destroyableObjects == null) {
            this.destroyableObjects = new LinkedList<WeakReference<Destroyable>>();
        }
        this.destroyableObjects.add(new WeakReference<Destroyable>(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForAbort() {
        Object object = this.abortLock;
        synchronized (object) {
            try {
                this.abortLock.wait(500L);
            }
            catch (InterruptedException e) {
                Log.logSevere(e);
            }
            return this.aborted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request waitResponse() {
        Request req;
        Object object = this.requestLock;
        synchronized (object) {
            while (this.request == null) {
                try {
                    this.requestLock.wait(this.getTimeToLive());
                }
                catch (InterruptedException e) {
                    this.setState(6);
                    throw new AbortedException();
                }
                catch (AbortedException e) {
                    this.setState(6);
                    throw e;
                }
                catch (TimeoutException e) {
                    this.setState(7);
                    throw e;
                }
            }
            req = this.request;
            this.request = null;
        }
        this.thread.setResponse(req.getResponse());
        return req;
    }

    static {
        int i = -1;
        NEW = i;
        nextIdLock = new Object();
        nextId = 0;
        runningContexts = Collections.synchronizedMap(new HashMap());
        nextId = (int)(System.currentTimeMillis() & 0x3FFFFC00L);
    }

    public static interface ExceptionFactory {
        public Exception createException(int var1);
    }
}

