/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import oracle.bpm.component.Instantiator;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;

public class Component {
    private static boolean consoleMode;
    private static InheritableThreadLocal location;
    private static InheritableThreadLocal runningOnDebugger_sd;
    private static InheritableThreadLocal connectorService;
    public static final String SERVER_SIDE = "SERVER";
    public static final String CLIENT_SIDE = "CLIENT";
    public static final String BROWSER = "BROWSER";
    private static boolean applet;
    private static boolean emulateJ2EE;

    public static void setConnectorService(ConnectorService service) {
        connectorService.set(service);
    }

    public static ConnectorService getConnectorService() {
        return (ConnectorService)connectorService.get();
    }

    public static void setConsoleMode(boolean value) {
        consoleMode = value;
    }

    public static void setEmulatedJ2EE(boolean emulateJ2EE) {
        Component.emulateJ2EE = emulateJ2EE;
    }

    public static boolean isEmulatedJ2EE() {
        return emulateJ2EE;
    }

    public static void setLocation(String location) {
        Component.location.set(location);
        if (BROWSER.equals(location)) {
            applet = true;
        }
    }

    public static String getLocation() {
        return (String)location.get();
    }

    public static boolean isNotRunningOnServer() {
        return Component.isRunningOnClientSide() || Component.isRunningOnBrowser();
    }

    public static boolean isRunningOnBrowser() {
        return BROWSER.equals(location.get()) || applet;
    }

    public static boolean isRunningOnClientSide() {
        return CLIENT_SIDE.equals(location.get()) && !applet;
    }

    public static void setRunningOnDebugger() {
        runningOnDebugger_sd.set(Boolean.TRUE);
    }

    public static boolean isRunningOnDebugger() {
        return Boolean.TRUE.equals(runningOnDebugger_sd.get());
    }

    public static boolean isRunningOnServerSide() {
        return SERVER_SIDE.equals(location.get());
    }

    public static boolean enableClient(boolean enabled) {
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        if (ctx != null) {
            enabled = ctx.enableClient(enabled);
        }
        return enabled;
    }

    public static Invokeable instantiateDynamic(String componentType, String configName, String qualifiedName, String classname, String constructor, Object[] args) throws ClassNotFoundException, ComponentExecutionException {
        Instantiator instantiator = Instantiator.forName(componentType, configName);
        return instantiator.instantiate(qualifiedName, classname, constructor, args);
    }

    public static Invokeable instantiateRemoteDynamic(String componentType, String configName, String qualifiedName, String classname, String constructor, Object[] args) throws ClassNotFoundException, ComponentExecutionException {
        if (consoleMode) {
            return Component.instantiateAlternative(classname, "Console");
        }
        if (!Component.isRunningOnServerSide()) {
            return Component.instantiateDynamic(componentType, configName, qualifiedName, classname, constructor, args);
        }
        ExecutionContext context = ExecutionContextAccessor.getContext();
        boolean clientAvailable = context.isClientAvailable();
        if (clientAvailable) {
            return context.instantiateRemoteComponent(componentType, configName, qualifiedName, classname, constructor, args);
        }
        return Component.instantiateAlternative(classname, "Batch");
    }

    static Throwable fixStackTrace(Object o) {
        Throwable t = (Throwable)o;
        StackTraceElement[] remote = t.getStackTrace();
        t.fillInStackTrace();
        StackTraceElement[] local = t.getStackTrace();
        int nslen = remote.length + local.length - 1;
        if (nslen > 0) {
            StackTraceElement[] resulting = new StackTraceElement[nslen];
            System.arraycopy(remote, 0, resulting, 0, remote.length);
            System.arraycopy(local, 1, resulting, remote.length, local.length - 1);
            t.setStackTrace(resulting);
        } else {
            t.setStackTrace(remote);
        }
        return t;
    }

    private static Invokeable instantiateAlternative(String classname, String prefix) throws ComponentExecutionException {
        try {
            int dot = classname.lastIndexOf(".");
            String javaClassName = dot != -1 ? classname.substring(0, dot) + "." + prefix + classname.substring(dot + 1) : prefix + classname;
            return new JavaObject(javaClassName, true, new JavaObject.ClassNotFoundHandler(){

                @Override
                public void handle(ClassNotFoundException ex) {
                    throw new RuntimeExceptionShell(new ComponentExecutionException(LibMsg.SERVER_METHOD_WITH_NO_CLIENT));
                }
            });
        }
        catch (IllegalAccessException e) {
            throw new ComponentExecutionException(e);
        }
        catch (InstantiationException e) {
            throw new ComponentExecutionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentExecutionException(LibMsg.SERVER_METHOD_WITH_NO_CLIENT);
        }
    }

    static {
        location = new InheritableThreadLocal(){

            @Override
            protected synchronized Object initialValue() {
                return Component.CLIENT_SIDE;
            }
        };
        runningOnDebugger_sd = new InheritableThreadLocal(){

            @Override
            protected synchronized Object initialValue() {
                return Boolean.FALSE;
            }
        };
        connectorService = new InheritableThreadLocal(){

            @Override
            protected synchronized Object initialValue() {
                return null;
            }
        };
        applet = false;
        emulateJ2EE = false;
    }
}

