/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import oracle.bpm.component.Batch;
import oracle.bpm.component.Component;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.Message;
import oracle.bpm.component.RemoteReference;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.TraceableInvokeable;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.util.ExecutionContextAccessor;

class ClientRemoteComponent
extends TraceableInvokeable {
    private Object[] args = null;
    private String className = null;
    private String componentType = null;
    private String configName = null;
    private String constructor = null;
    private Integer objectId;
    private String qualifiedName;
    private Interval timeout;
    static final long serialVersionUID = -7954600318003721530L;
    static final long serialCheck = -4160246450403865012L;

    ClientRemoteComponent(String moduleType, String moduleName, String qualifiedName, String classname, String constructor, Object[] args) {
        this.componentType = moduleType;
        this.configName = moduleName;
        this.qualifiedName = qualifiedName;
        this.className = classname;
        this.constructor = constructor;
        this.args = args;
        this.objectId = null;
    }

    @Override
    public void setAttributeValue(String signature, int index, Object value) {
        if (signature.equals("Atimeout;")) {
            this.setTimeout((Interval)value);
        }
        Message request = Message.createSetAttribute(ExecutionThreadContext.current().getId(), signature, index, value);
        try {
            this.doInvocation(request, false);
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    @Override
    public Object getAttributeValue(String signature, String setter, int index) {
        if (signature.equals("Atimeout;")) {
            return this.timeout;
        }
        if (Component.isEmulatedJ2EE()) {
            throw new UnsupportedOperationException("Cannot invoke on remote components");
        }
        Message request = Message.createGetAttribute(ExecutionThreadContext.current().getId(), signature, setter, index);
        try {
            return this.doInvocation(request, true);
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    @Override
    public String getName() {
        return "" + (this.configName != null ? this.configName + "." : "") + this.className;
    }

    @Override
    public Object invoke(String methodSignature, Object ... args) throws ComponentExecutionException {
        if (Component.isEmulatedJ2EE()) {
            throw new UnsupportedOperationException("Cannot invoke on remote components");
        }
        try {
            return this.invoke(methodSignature, true, args, (Object[])null);
        }
        catch (Exception e) {
            if (e instanceof ComponentExecutionException) {
                throw (ComponentExecutionException)e;
            }
            throw new ComponentExecutionException(e);
        }
    }

    @Override
    public Object invokeImpl(String signature, boolean synchronous, Object[] inputArgs, Object[] outputArgs) throws ComponentExecutionException {
        int outSize;
        inputArgs = this.checkTimeout(inputArgs);
        boolean bl = synchronous = synchronous || outputArgs != null;
        if (synchronous && Component.isEmulatedJ2EE()) {
            throw new UnsupportedOperationException("Cannot invoke on remote components");
        }
        Message request = Message.createClientInvoke(ExecutionThreadContext.current().getId(), signature, synchronous, inputArgs, outputArgs);
        Object[] results = (Object[])this.doInvocation(request, synchronous);
        int n = outSize = results == null ? 0 : results.length;
        if (outputArgs != null) {
            for (int i = 0; i < outputArgs.length; ++i) {
                outputArgs[i] = this.processReference(i < outSize - 1 && results != null ? results[i + 1] : null);
            }
        }
        return this.processReference(outSize == 0 ? null : results[0]);
    }

    @Override
    public void invokeRelayTo(String methodSignature, Object[] inputArgs, Object target, String targetMtd, Object[] bindings) throws Exception {
        inputArgs = this.checkTimeout(inputArgs);
        Message request = Message.createChainedInvoke(ExecutionThreadContext.current().getId(), methodSignature, target, targetMtd, inputArgs, bindings);
        this.doInvocation(request, false);
    }

    void setTimeout(Interval interval) {
        this.timeout = interval;
        ExecutionThreadContext ctx = ExecutionThreadContext.current();
        if (interval != null && ctx != null) {
            ctx.setTimeout(interval.getMicroSeconds() / 1000L);
        }
    }

    private Object[] checkTimeout(Object[] inputArgs) {
        if (inputArgs == null) {
            return null;
        }
        int len = inputArgs.length;
        for (int i = 0; i < len; i += 2) {
            if (!"Atimeout;".equals(inputArgs[i])) continue;
            this.setTimeout((Interval)inputArgs[i + 1]);
            Object[] tmp = new Object[len -= 2];
            if (i > 0) {
                System.arraycopy(inputArgs, 0, tmp, 0, i);
            }
            if (len > i) {
                System.arraycopy(inputArgs, i + 2, tmp, i, len - i);
            }
            inputArgs = tmp;
        }
        return inputArgs;
    }

    private Object doInvocation(Message request, boolean waitResult) throws ComponentExecutionException {
        ExecutionThreadContext ctx = ExecutionThreadContext.current();
        if (this.objectId != null) {
            request.setObjectId(this.objectId);
        } else {
            if (!ExecutionContextAccessor.getContext().isClientAvailable()) {
                throw new ComponentExecutionException(LibMsg.SERVER_METHOD_WITH_NO_CLIENT);
            }
            Message cons = Message.createInstantiate(ExecutionThreadContext.current().getId(), this.componentType, this.configName, this.qualifiedName, this.className, this.constructor, this.args);
            ctx.addResponse(cons);
            if (!waitResult) {
                Batch list = ctx.doClientInvoke();
                assert (list.size() == 1) : "List size should be one";
                this.objectId = (Integer)this.processResult(list.remove());
            }
        }
        ctx.addResponse(request);
        if (request.isAsyncInvoke()) {
            return null;
        }
        Batch list = ctx.doClientInvoke();
        if (this.objectId == null) {
            this.objectId = (Integer)this.processResult(list.remove());
        }
        Object result = null;
        if (!ctx.inRelay()) {
            assert (list.size() == 1) : "List size should be one";
            Message response = list.remove();
            if (waitResult) {
                result = this.processReference(this.processResult(response));
            } else {
                assert (response.isEmpty()) : "Response should be empty";
                result = null;
            }
        }
        return result;
    }

    private Object processReference(Object object) {
        if (object instanceof RemoteReference) {
            RemoteReference ref = (RemoteReference)object;
            ClientRemoteComponent inv = new ClientRemoteComponent(this.componentType, this.configName, this.qualifiedName, "<Unknown>", null, null);
            inv.objectId = ref.getValue();
            return inv;
        }
        return object;
    }

    private Object processResult(Message response) throws ComponentExecutionException {
        if (response.isReturnValue()) {
            return response.getValue();
        }
        if (response.isException()) {
            throw new ComponentExecutionException(Component.fixStackTrace(response.getValue()));
        }
        assert (false) : "Invalid response : " + response;
        return null;
    }
}

