/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.bpm.component.Message;

public final class Batch
implements Serializable {
    private Message first;
    private Message last;
    private int size;
    static final long serialVersionUID = 1000801081712000002L;
    static final long serialCheck = -2613619739681400779L;

    public Batch() {
    }

    Batch(Message request) {
        this.add(request);
    }

    public static Batch createTestList() {
        Integer sessionId = Integer.MAX_VALUE;
        Batch rl = new Batch();
        rl.add(Message.createAbort());
        rl.add(Message.createEmpty(sessionId));
        rl.add(Message.createException(sessionId, new Exception("Test exception")));
        rl.add(Message.createReturn(sessionId, "Test return value"));
        return rl;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public Integer getId() {
        return this.get().getId();
    }

    public Batch add(Message request) {
        if (this.first == null) {
            this.first = request;
            this.last = request;
        } else {
            this.last.setNext(request);
            this.last = request;
        }
        ++this.size;
        return this;
    }

    public Message get() {
        return this.first;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        for (Message current = this.first; current != null; current = current.getNext()) {
            if (current != this.first) {
                buffer.append(',');
            }
            buffer.append(current);
        }
        buffer.append(']');
        return buffer.toString();
    }

    void clear() {
        this.size = 0;
        this.first = null;
        this.last = null;
    }

    Message remove() {
        Message first = this.first;
        this.first = first.getNext();
        first.setNext(null);
        if (--this.size == 0) {
            this.last = null;
        }
        return first;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add((Message)in.readObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        for (Message current = this.first; current != null; current = current.getNext()) {
            Message next = current.getNext();
            current.setNext(null);
            try {
                out.writeObject(current);
                continue;
            }
            finally {
                current.setNext(next);
            }
        }
    }
}

