/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject;

import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public final class BpmObjectFactory {
    private BpmObjectFactory() {
    }

    public static void setProperties(ObjectTypeDescription object) {
        object.setTransientProperty("generateStubs", "true");
        object.setTransientProperty("generateBitSets", "true");
        object.setTransientProperty("packagePrefix", "xobject");
        object.setComponentType(ComponentType.XOBJECT.getText());
    }

    public static XObjectTypeDescription createXObjectTypeDescription(@NotNull String name, @NotNull String module, @NotNull ComponentCatalog catalog, boolean instanciable) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        return BpmObjectFactory.createXObjectTypeDescription(name, module, catalog, instanciable, false);
    }

    public static XObjectTypeDescription createCallbackXObjectTypeDescription(@NotNull ComponentCatalog catalog, @NotNull XObjectTypeDescription serviceObject, @NotNull WsdlTypeDescription callbackPortType, @NotNull String serviceObjectModule) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createCallbackXObjectTypeDescription must not be null");
        }
        if (serviceObject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createCallbackXObjectTypeDescription must not be null");
        }
        if (callbackPortType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createCallbackXObjectTypeDescription must not be null");
        }
        if (serviceObjectModule == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createCallbackXObjectTypeDescription must not be null");
        }
        XObjectTypeDescription result = BpmObjectFactory.createCallbackXObjectTypeDescription("Callback", serviceObjectModule + "." + serviceObject.getName(), catalog);
        String target = serviceObject.getProperty("target");
        result.setProperty("target", target);
        String targetPort = serviceObject.getProperty("target.port");
        result.setProperty("target.port", targetPort);
        result.setProperty("service.object.id", UUIDFactory.createServiceId(callbackPortType.getNamespace(), callbackPortType.getNativeName(), target, targetPort).getId());
        result.setProperty("is.callback", Boolean.TRUE.toString());
        serviceObject.addInnerType(result.getRef());
        return result;
    }

    public static XObjectTypeDescription createXObjectTypeDescription(@NotNull String name, @NotNull String module, @NotNull ComponentCatalog catalog) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        return BpmObjectFactory.createXObjectTypeDescription(name, module, catalog, false);
    }

    public static XObjectTypeDescription createXObjectTypeDescriptionWithExtAttr(String name, ComponentCatalog catalog, XmlTypeDescription xmlotd) {
        String className = Identifier.classname(name);
        XObjectTypeDescription result = XObjectTypeDescription.create(className, xmlotd.getKind());
        DynamicRef schemaRef = new DynamicRef(xmlotd, catalog);
        String schemaId = xmlotd.getId();
        return BpmObjectFactory.createXObjectTypeDescriptionWithExtAttr(catalog, result, schemaRef, schemaId);
    }

    public static XObjectTypeDescription createXObjectTypeDescriptionWithExtAttr(String name, ComponentCatalog catalog, XmlUUID xmlUUID) {
        String className = Identifier.classname(name);
        XObjectTypeDescription result = XObjectTypeDescription.create(className, 11);
        DynamicRef schemaRef = new DynamicRef(xmlUUID, xmlUUID.getNativeName(), catalog);
        String schemaId = xmlUUID.getId();
        return BpmObjectFactory.createXObjectTypeDescriptionWithExtAttr(catalog, result, schemaRef, schemaId);
    }

    private static XObjectTypeDescription createXObjectTypeDescriptionWithExtAttr(ComponentCatalog catalog, XObjectTypeDescription result, TypeRef schemaRef, String schemaId) {
        result.setCatalog(catalog);
        SuperType superType = new SuperType(schemaRef, 0x800000L);
        result.addSuperType(superType);
        result.setProperty("attributes.schema.id", schemaId);
        BpmObjectFactory.setProperties(result);
        return result;
    }

    private static XObjectTypeDescription createXObjectTypeDescription(@NotNull String name, @NotNull String parentModule, @NotNull ComponentCatalog catalog, boolean instanciable, boolean isCallback) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        if (parentModule == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createXObjectTypeDescription must not be null");
        }
        String className = Identifier.classname(name);
        XObjectTypeDescription result = new XObjectTypeDescription(className, instanciable);
        result.setCatalog(catalog);
        result.setModifiers(0L);
        BpmObjectFactory.setProperties(result);
        XmlTypeDescription xmlotd = XmlTypeDescription.createForBpmObjectSchema(result, parentModule, isCallback);
        result.addSuperType(new SuperType(xmlotd, 0x800000L));
        result.setProperty("attributes.schema.id", xmlotd.getId());
        return result;
    }

    private static XObjectTypeDescription createCallbackXObjectTypeDescription(@NotNull String name, @NotNull String module, @NotNull ComponentCatalog catalog) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createCallbackXObjectTypeDescription must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createCallbackXObjectTypeDescription must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bpmobject/BpmObjectFactory.createCallbackXObjectTypeDescription must not be null");
        }
        return BpmObjectFactory.createXObjectTypeDescription(name, module, catalog, false, true);
    }
}

