/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFormater {
    private Environment enviroment;
    private Pattern searchPattern;

    public TextFormater(Environment enviroment, Pattern searchPattern) {
        this.enviroment = enviroment;
        this.searchPattern = searchPattern;
    }

    public String format(String text) {
        StringBuffer textBuffer = new StringBuffer(text);
        Matcher matcher = this.searchPattern.matcher(textBuffer);
        while (matcher.find(0)) {
            int cursor = 0;
            while (matcher.find(cursor)) {
                String value = this.enviroment.evaluateExpression(matcher);
                if (value != null) {
                    char[] result = value.toCharArray();
                    textBuffer.delete(matcher.start(), matcher.end());
                    textBuffer.insert(matcher.start(), result, 0, result.length);
                    cursor = matcher.start() + result.length;
                    continue;
                }
                cursor = matcher.end();
            }
        }
        return textBuffer.toString();
    }

    public static class DefaultEnviroment
    implements Environment {
        private Map<String, String>[] values;

        public DefaultEnviroment(Map<String, String> ... values) {
            this.values = values;
        }

        @Override
        public String evaluateExpression(Matcher matcher) {
            String expresion = matcher.group(1);
            for (Map<String, String> value : this.values) {
                String result = value.get(expresion);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    public static interface Environment {
        public String evaluateExpression(Matcher var1);
    }
}

