/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.lang.Any;
import oracle.bpm.project.io.ProjectAlreadyExistsException;
import oracle.bpm.project.io.UnzipListener;
import oracle.bpm.project.io.fs.export.ProjectZipper;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportProjectWizardUserObject;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiRunnableDecorator;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.wizards.model.WizardStep;

public class UnzipProjectRunnable
implements Runnable {
    private ImportProjectWizardUserObject importWizard;
    private UnzipListener listener;
    private Runnable next;
    private final WizardStep step;
    private Collection<File> unzippedFiles = new ArrayList<File>();

    public UnzipProjectRunnable(WizardStep step, ImportProjectWizardUserObject object, UnzipListener listener, Runnable next) {
        this.step = step;
        this.importWizard = object;
        this.listener = listener;
        this.next = next;
    }

    @Override
    public void run() {
        File file = new File(this.importWizard.getProjectFileLocation());
        File baseDir = new File(this.importWizard.getProjectRootDirectory());
        List<ProjectZipper.Entry> entries = this.importWizard.getEntries();
        for (ProjectZipper.Entry entry : entries) {
            this.unzipProject(file, baseDir, entry.getZipEntryName(), entry.getProjectName());
        }
        if (!this.unzippedFiles.isEmpty() && this.next != null) {
            this.importWizard.setProjectFiles(this.unzippedFiles);
            new UiRunnableDecorator(0, this.next).run();
        }
        UiUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (UnzipProjectRunnable.this.unzippedFiles != null) {
                    UnzipProjectRunnable.this.step.getNextButton().setEnabled(true);
                } else {
                    Button button = UnzipProjectRunnable.this.step.getBackButton();
                    if (button != null) {
                        button.setEnabled(true);
                    }
                    UnzipProjectRunnable.this.step.getCancelButton().setEnabled(true);
                }
            }
        });
    }

    private void unzipProject(File file, File baseDir, String oldProjectName, final String projectName) {
        block4: {
            try {
                this.unzippedFiles.add(ProjectZipper.create().unzipProject(file, baseDir, false, this.listener, oldProjectName, projectName));
            }
            catch (ProjectAlreadyExistsException e) {
                final Any.Holder option = new Any.Holder();
                UiUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        option.value = MessageDialog.showQuestion((UiContainer)null, UIMsg.WARNING, ProjectMsg.PROJECT_DIR_ALREADY_EXISTS_OVERWRITE((String)projectName), null, 6, null);
                    }
                });
                if ((Integer)option.value != 2) break block4;
                try {
                    this.unzippedFiles.add(ProjectZipper.create().unzipProject(file, baseDir, true, this.listener, oldProjectName, projectName));
                }
                catch (ProjectAlreadyExistsException e1) {
                    // empty catch block
                }
            }
        }
    }
}

