/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import java.util.List;
import oracle.bpm.geom.Insets;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.io.fs.InvalidExportFileException;
import oracle.bpm.project.io.fs.export.ProjectZipper;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.validators.ImportFuegoProjectDestinationValidator;
import oracle.bpm.project.ui.validators.ImportFuegoProjectFileValidator;
import oracle.bpm.project.ui.wizards.ImportProjectWizardUserObject;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.filechooser.DirectoryChooser;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.FileFilter;

public class ProjectFileLocationStep
extends WizardStep {
    protected ProjectFileLocationPanel projectNamePanel;

    public ProjectFileLocationStep(Wizard owner) {
        super(owner);
    }

    @Override
    public boolean doProcess() {
        ((ImportProjectWizardUserObject)this.getWizard().getUserObject()).setProjectFileLocation(this.projectNamePanel.getSelectedFileLocation());
        ((ImportProjectWizardUserObject)this.getWizard().getUserObject()).setProjectRootDirectory(this.projectNamePanel.getSelectedRootLocation());
        CommonPreferences.getInstance().setLastUsedDir(this.projectNamePanel.getSelectedRootLocation());
        return true;
    }

    @Override
    public WizardStepPanel getPanelFor(UiContainer parent) {
        if (this.projectNamePanel == null) {
            this.projectNamePanel = new ProjectFileLocationPanel(parent, this);
        }
        return this.projectNamePanel;
    }

    @Override
    public void undoProcess() {
    }

    protected class ProjectFileLocationPanel
    extends WizardStepPanel {
        Button browseExportFileButton;
        TextField projectFile_d;
        TextField projectRoot;

        public ProjectFileLocationPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        @Override
        public UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.PROJECT_LOCATION_TITLE);
            this.setPageDesc(ProjectMsg.PROJECT_FILE_AND_LOCATION_DESCR);
            Panel centerPanel = new Panel(parent);
            centerPanel.setLayout(new BorderLayout());
            Panel projectLocationPanel = new Panel(centerPanel);
            projectLocationPanel.setLayout(new GridBagLayout());
            Label projectFileLocationLabel = Label.create(projectLocationPanel);
            projectFileLocationLabel.setMsg(ProjectMsg.PROJECT_EXP_FILE);
            Label projectRootLocationLabel = Label.create(projectLocationPanel);
            projectRootLocationLabel.setMsg(ProjectMsg.PROJECT_ROOT_DIRECTORY);
            this.projectFile_d = new TextField((UiContainer)projectLocationPanel, this.getExportFileValue());
            Panel browseButtonPanel = new Panel(projectLocationPanel);
            browseButtonPanel.setLayout(new FlowLayout());
            this.browseExportFileButton = new Button((UiContainer)browseButtonPanel, UIMsg.BROWSE);
            this.browseExportFileButton.addActionListener(new BrowseForExportActionListener());
            browseButtonPanel.add(this.browseExportFileButton);
            this.projectRoot = new TextField((UiContainer)projectLocationPanel, this.getInitialRootDir());
            Panel browseRootButtonPanel = new Panel(projectLocationPanel);
            browseRootButtonPanel.setLayout(new FlowLayout());
            Button browseProjectRootButton = new Button((UiContainer)browseRootButtonPanel, UIMsg.BROWSE);
            browseProjectRootButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DirectoryChooser chooser = new DirectoryChooser();
                    File projectDir = new File(ProjectFileLocationPanel.this.projectRoot.getText());
                    chooser.setSelectedFile(projectDir);
                    chooser.setCurrentDirectory(projectDir);
                    int result = chooser.show(Ui.getRoot());
                    if (chooser.getSelectedFile() == null) {
                        return;
                    }
                    switch (result) {
                        case 0: {
                            ProjectFileLocationPanel.this.projectRoot.setText(chooser.getSelectedFile().getAbsolutePath());
                            break;
                        }
                    }
                }
            });
            browseRootButtonPanel.add(browseProjectRootButton);
            projectLocationPanel.add(projectFileLocationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 8, 2), 0, 0));
            projectLocationPanel.add(this.projectFile_d, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 8, 2), 0, 0));
            projectLocationPanel.add(browseButtonPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            projectLocationPanel.add(projectRootLocationLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 8, 2), 0, 0));
            projectLocationPanel.add(this.projectRoot, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 8, 2), 0, 0));
            projectLocationPanel.add(browseRootButtonPanel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
            LabelMultiline area = ProjectFileLocationPanel.createTextArea((UiContainer)centerPanel, ProjectMsg.SELECT_FILE_ROOT);
            centerPanel.add(area, "North");
            centerPanel.add(projectLocationPanel, "Center");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProjectFileLocationPanel.this.projectFile_d.selectAll();
                    ProjectFileLocationPanel.this.projectFile_d.requestFocus();
                }
            };
            UiUtilities.invokeLater(runnable);
            return centerPanel;
        }

        public String getSelectedFileLocation() {
            return this.projectFile_d.getText();
        }

        public String getSelectedRootLocation() {
            return this.projectRoot.getText();
        }

        @Override
        public boolean validateInput() {
            try {
                new ImportFuegoProjectFileValidator().validate(this.projectFile_d.getText());
                new ImportFuegoProjectDestinationValidator().validate(this.projectRoot.getText());
            }
            catch (InputValidationException e) {
                MessageDialog.showError(e.getKey());
                return false;
            }
            return this.setProjectName();
        }

        private boolean setProjectName() {
            File zipFile = new File(this.projectFile_d.getText());
            try {
                List entries = ProjectZipper.create().getEntries(zipFile);
                ((ImportProjectWizardUserObject)this.getWizardStep().getWizard().getUserObject()).setEntries(entries);
                CommonPreferences commonPref = CommonPreferences.getInstance();
                commonPref.setLastUsedImportProjectFile(zipFile.getAbsolutePath());
                commonPref.store();
            }
            catch (InvalidExportFileException e) {
                MessageDialog.showError(e.getMsg());
                return false;
            }
            return true;
        }

        private String getExportFileValue() {
            File f;
            CommonPreferences preferences;
            String lastUsedFile;
            String fileLocation;
            String obj = ((ImportProjectWizardUserObject)this.getWizardStep().getWizard().getUserObject()).getProjectFileLocation();
            String string = fileLocation = obj != null ? obj : "";
            if (fileLocation.equals("") && (lastUsedFile = (preferences = CommonPreferences.getInstance()).getLastUsedImportProjectFile()) != null && (f = new File(lastUsedFile)).exists()) {
                fileLocation = f.getAbsolutePath();
            }
            return fileLocation;
        }

        private String getInitialRootDir() {
            ImportProjectWizardUserObject userObject = (ImportProjectWizardUserObject)this.getWizardStep().getWizard().getUserObject();
            String result = userObject.getProjectRootDirectory();
            if (result != null) {
                return result;
            }
            return RepositoryService.getInstance().getActiveRepository().getDefaultBaseDir().getPath();
        }

        private class BrowseForExportActionListener
        implements ActionListener {
            private BrowseForExportActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooser chooser = new FileChooser();
                FileFilter projectFilter = FileFilter.create(UIMsg.EXPORTED_PROJECT_FILES, ".exp");
                chooser.addChoosableFileFilter(projectFilter);
                chooser.setFileFilter(projectFilter);
                chooser.setName("studio.exported.files");
                int result = chooser.showOpenDialog(Ui.getRoot());
                if (chooser.getSelectedFile() == null) {
                    return;
                }
                if (result == 0) {
                    ProjectFileLocationPanel.this.projectFile_d.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        }
    }
}

