/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.project.ui.wizards.ProjectKeeper;
import oracle.bpm.project.ui.wizards.ProjectNameAndRootPanel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.util.CommonPreferences;

public class ProjectExportFileLocationStep
extends WizardStep {
    protected ExportPanel panel;
    private ProjectKeeper prjKeeper;

    public ProjectExportFileLocationStep(Wizard owner, ProjectKeeper prjKeeper) {
        super(owner);
        this.prjKeeper = prjKeeper;
    }

    @Override
    public WizardStepPanel getPanelFor(UiContainer parent) {
        if (this.panel == null) {
            this.panel = new ExportPanel(parent, this.prjKeeper.getProject());
        }
        return this.panel;
    }

    @Override
    public boolean doProcess() {
        String exportPath = this.panel.getExportPath();
        ((ImportWizardUserObject)this.getWizard().getUserObject()).setProjectFileLocation(exportPath);
        return true;
    }

    @Override
    public void undoProcess() {
    }

    private class ExportPanel
    extends ProjectNameAndRootPanel {
        private Project project;

        public ExportPanel(UiContainer parent, Project project) {
            super(parent, ProjectExportFileLocationStep.this);
            this.project = project;
        }

        public String getExportPath() {
            return this.getRootDir() + this.getProjectName() + ".exp";
        }

        @Override
        public boolean validateInput() {
            File parentFile;
            boolean ok = super.validateInput();
            if (!ok) {
                return false;
            }
            File exportFile = new File(this.getExportPath());
            if (exportFile.exists()) {
                if (exportFile.isDirectory()) {
                    MessageDialog.showError(ProjectMsg.INVALID_FILE_FOR_EXPORT((String)exportFile.getName()));
                    return false;
                }
                if (MessageDialog.showQuestion((UiContainer)null, CoreMsg.WARNING, ProjectMsg.FILE_EXISTS_OVEWRITE, null, 6, null) != 2) {
                    return false;
                }
                if (!exportFile.canWrite()) {
                    MessageDialog.showError(ProjectMsg.FILE_IS_READ_ONLY);
                    return false;
                }
            }
            if ((parentFile = exportFile.getParentFile()) != null) {
                CommonPreferences.getInstance().setLastUsedExportPath(parentFile.getAbsolutePath());
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    MessageDialog.showError(ProjectMsg.FILE_IS_READ_ONLY);
                    return false;
                }
            }
            return true;
        }

        @Override
        protected void setPanelTitle() {
            this.setPageTitle(ProjectMsg.PROJECT_LOCATION_TITLE);
            this.setPageDesc(ProjectMsg.EXPORT_PROJECT_FILE_AND_LOCATION_DESCR);
        }

        @Override
        protected String getInitialName() {
            return this.project.getName();
        }

        @Override
        protected String getInitialRootDir() {
            String fileLocation = CommonPreferences.getInstance().getLastUsedExportPath();
            if (fileLocation == null || fileLocation.equals("")) {
                fileLocation = System.getProperty("user.home");
            }
            return fileLocation;
        }

        @Override
        protected Msg getFileLocationIsNullMsg() {
            return ProjectMsg.EXPORT_FILE_LOCATION_IS_NULL;
        }

        @Override
        protected Msg getProjectRootDirectoryMsg() {
            return ProjectMsg.PROJECT_EXPORT_TARGET_DIRECTORY;
        }
    }
}

