/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardExecutorStep;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.model.WizardSwingWorker;
import oracle.bpm.ui.wizards.model.WizardSwingWorkerExecutorAdaptor;
import oracle.bpm.ui.wizards.ui.DynamicExecutorPanel;

class ProjectCreationPanel
extends DynamicExecutorPanel {
    Button browseButton_d;
    private LabelMultiline area;
    private static final String CRLF = "\r\n";

    public ProjectCreationPanel(UiContainer parent, WizardStep wizardStep) {
        super(parent, wizardStep);
    }

    @Override
    public void setTaskText(String text) {
    }

    public void close(ActionEvent e) {
        WizardSwingWorker worker = new WizardSwingWorker(new WizardSwingWorkerExecutorAdaptor((WizardExecutorStep)this.getWizardStep()){

            @Override
            protected void finishActionIn(WizardSwingWorker worker) {
                super.finishActionIn(worker);
                ProjectCreationPanel.super.close();
            }
        });
        worker.start();
    }

    @Override
    public void onFocus() {
        this.updateFromRoot();
    }

    @Override
    protected UiComponent createCenterPage(UiContainer parent) {
        this.setPageTitle(ProjectMsg.NEW_PROJECT_INFORMATION_SUMMARY_LABEL);
        this.setPageDesc(ProjectMsg.NEW_PROJECT_INFORMATION_SUMMARY_DESC);
        this.area = ProjectCreationPanel.createTextArea(parent, this.getSummaryText());
        this.area.setBackground(UiManager.color("TextArea.background"));
        this.area.setBorder(BorderFactory.createLineBorder(UiManager.color("controlDkShadow")));
        this.area.setSize(600, 600);
        return this.area;
    }

    void updateFromRoot() {
        String text = this.getSummaryText();
        this.area.setMsg(UIMsg.TO_MSG(text));
    }

    private String getSummaryText() {
        Wizard wizard = this.getWizardStep().getWizard();
        StringBuffer buffer = new StringBuffer();
        buffer.append(ProjectMsg.PROJECT_NAME);
        buffer.append(":");
        buffer.append(CRLF);
        buffer.append(((ImportWizardUserObject)wizard.getUserObject()).getProjectName());
        buffer.append(CRLF);
        buffer.append(CRLF);
        buffer.append(ProjectMsg.PROJECT_ROOT_DIRECTORY);
        buffer.append(":");
        buffer.append(CRLF);
        buffer.append(((ImportWizardUserObject)wizard.getUserObject()).getProjectRootDirectory());
        buffer.append(CRLF);
        buffer.append(CRLF);
        return buffer.toString();
    }
}

