/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.events;

import oracle.bpm.lang.Any;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.UiUtilities;

public class UiProjectAdapter<PO extends ProjectObject>
implements ProjectListener<PO> {
    ProjectListener<PO> decoratee;

    public UiProjectAdapter(ProjectListener<PO> listener) {
        this.decoratee = listener;
    }

    public Class<PO> getSupportedTypes() {
        return this.decoratee.getSupportedTypes();
    }

    public void objectChanged(PO projectObject, ProjectEvent event) {
        UiUtilities.invokeLater(new Runnable((ProjectObject)projectObject, event){
            final /* synthetic */ ProjectObject val$projectObject;
            final /* synthetic */ ProjectEvent val$event;
            {
                this.val$projectObject = projectObject;
                this.val$event = projectEvent;
            }

            @Override
            public void run() {
                UiProjectAdapter.this.decoratee.objectChanged(this.val$projectObject, this.val$event);
            }
        });
    }

    public void objectReplaced(PO oldObject, PO newObject) {
        UiUtilities.invokeLater(new Runnable((ProjectObject)oldObject, (ProjectObject)newObject){
            final /* synthetic */ ProjectObject val$oldObject;
            final /* synthetic */ ProjectObject val$newObject;
            {
                this.val$oldObject = projectObject;
                this.val$newObject = projectObject2;
            }

            @Override
            public void run() {
                UiProjectAdapter.this.decoratee.objectReplaced(this.val$oldObject, this.val$newObject);
            }
        });
    }

    public void postObjectAdded(PO object, ProjectObject parent) {
        UiUtilities.invokeLater(new Runnable((ProjectObject)object, parent){
            final /* synthetic */ ProjectObject val$object;
            final /* synthetic */ ProjectObject val$parent;
            {
                this.val$object = projectObject;
                this.val$parent = projectObject2;
            }

            @Override
            public void run() {
                UiProjectAdapter.this.decoratee.postObjectAdded(this.val$object, this.val$parent);
            }
        });
    }

    public void postObjectRemoved(PO object, ProjectObject parent) {
        UiUtilities.invokeLater(new Runnable((ProjectObject)object, parent){
            final /* synthetic */ ProjectObject val$object;
            final /* synthetic */ ProjectObject val$parent;
            {
                this.val$object = projectObject;
                this.val$parent = projectObject2;
            }

            @Override
            public void run() {
                UiProjectAdapter.this.decoratee.postObjectRemoved(this.val$object, this.val$parent);
            }
        });
    }

    public void preObjectAdded(PO object, ProjectObject parent) throws ProjectException {
        Any.Holder exception = new Any.Holder();
        UiUtilities.invokeAndWait(new Runnable((ProjectObject)object, parent, exception){
            final /* synthetic */ ProjectObject val$object;
            final /* synthetic */ ProjectObject val$parent;
            final /* synthetic */ Any.Holder val$exception;
            {
                this.val$object = projectObject;
                this.val$parent = projectObject2;
                this.val$exception = holder;
            }

            @Override
            public void run() {
                try {
                    UiProjectAdapter.this.decoratee.preObjectAdded(this.val$object, this.val$parent);
                }
                catch (ProjectException e) {
                    this.val$exception.value = e;
                }
            }
        });
        if (exception.value != null) {
            throw (ProjectException)((Object)exception.value);
        }
    }

    public void preObjectRemoved(PO object, ProjectObject parent) throws ProjectException {
        Any.Holder exception = new Any.Holder();
        UiUtilities.invokeAndWait(new Runnable((ProjectObject)object, parent, exception){
            final /* synthetic */ ProjectObject val$object;
            final /* synthetic */ ProjectObject val$parent;
            final /* synthetic */ Any.Holder val$exception;
            {
                this.val$object = projectObject;
                this.val$parent = projectObject2;
                this.val$exception = holder;
            }

            @Override
            public void run() {
                try {
                    UiProjectAdapter.this.decoratee.preObjectRemoved(this.val$object, this.val$parent);
                }
                catch (ProjectException e) {
                    this.val$exception.value = e;
                }
            }
        });
        if (exception.value != null) {
            throw (ProjectException)((Object)exception.value);
        }
    }

    public void processPreEvents(final ProjectEventSet events) throws ProjectException {
        final Any.Holder exception = new Any.Holder();
        UiUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UiProjectAdapter.this.decoratee.processPreEvents(events);
                }
                catch (ProjectException e) {
                    exception.value = e;
                }
            }
        });
        if (exception.value != null) {
            throw (ProjectException)((Object)exception.value);
        }
    }

    public void processPostEvents(final ProjectEventSet events) {
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UiProjectAdapter.this.decoratee.processPostEvents(events);
            }
        });
    }
}

