/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.ui.selection.DefaultSelection;

public class ModelObjectSelection
extends DefaultSelection
implements Iterable<FlowElement> {
    protected boolean drawRectangle;
    private ArrayList<FlowElement> objects = new ArrayList();

    private ModelObjectSelection() {
        this.setAll(this.objects);
    }

    public static ModelObjectSelection create(List<? extends FlowElement> selection) {
        ModelObjectSelection modelObjectSelection = new ModelObjectSelection();
        for (FlowElement flowElement : selection) {
            modelObjectSelection.addObject(flowElement);
        }
        return modelObjectSelection;
    }

    public static ModelObjectSelection create(FlowElement ... selection) {
        ModelObjectSelection modelObjectSelection = new ModelObjectSelection();
        for (FlowElement modelObject : selection) {
            modelObjectSelection.internalAddObject(modelObject);
        }
        modelObjectSelection.addTransitions();
        return modelObjectSelection;
    }

    public static Sequence<FlowNode> getAllActivities(Collection<FlowElement> normalizedObjects) {
        return CollectionUtils.selectInstanceOf(CollectionUtils.asSequence(new ArrayList<FlowElement>(normalizedObjects)), FlowNode.class);
    }

    public Sequence<FlowNode> getActivities() {
        return ModelObjectSelection.getAllActivities(this.objects);
    }

    public Sequence<FlowNode> getActivities(List<FlowElement> list) {
        return ModelObjectSelection.getAllActivities(list);
    }

    public void clear() {
        this.objects.clear();
    }

    public boolean containsAllObjects(Collection<ModelObject> components) {
        return this.objects.containsAll(components);
    }

    public boolean containsObject(FlowNode dObj) {
        return this.objects.contains(dObj);
    }

    @Override
    public Iterator<FlowElement> iterator() {
        return this.objects.iterator();
    }

    public final void addObject(FlowElement flowElement) {
        if (flowElement == null) {
            return;
        }
        this.internalAddObject(flowElement);
    }

    public Sequence<SequenceFlow> getTransitions(Collection<FlowElement> normalizedObjects) {
        return CollectionUtils.selectInstanceOf(CollectionUtils.asSequence(new ArrayList<FlowElement>(normalizedObjects)), SequenceFlow.class);
    }

    public List<Positional> getPositionals() {
        ArrayList<Positional> result = new ArrayList<Positional>();
        for (FlowElement modelObject : this.objects) {
            if (!(modelObject instanceof Positional)) continue;
            result.add((Positional)modelObject);
        }
        return result;
    }

    public void ensureNecessary() {
        for (FlowNode node : this.getActivities()) {
            NodeAssociationFeature feature = (NodeAssociationFeature)node.getFeature(NodeAssociationFeature.class);
            if (feature == null || feature.getAssociatedNode() == null) continue;
            this.addObject((FlowElement)feature.getAssociatedNode());
        }
        this.addTransitions();
    }

    public Collection<FlowElement> normalizeForRemove() {
        TreeSet<FlowElement> normalizedObjects = new TreeSet<FlowElement>(new Comparator<FlowElement>(){

            @Override
            public int compare(FlowElement o1, FlowElement o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        normalizedObjects.addAll(this.objects);
        return normalizedObjects;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.drawRectangle ? 1231 : 1237);
        result = 31 * result + (this.objects == null ? 0 : this.objects.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelObjectSelection other = (ModelObjectSelection)obj;
        if (this.drawRectangle != other.drawRectangle) {
            return false;
        }
        return !(this.objects == null ? other.objects != null : !this.objects.equals(other.objects));
    }

    @Override
    public <T> T as(Class<T> targetType) {
        FlowElement element;
        if (targetType.isInstance(this)) {
            return targetType.cast(this);
        }
        if (targetType.equals(Process.class) && (element = CollectionUtils.first(this.objects)) != null) {
            return targetType.cast(element.getProcess());
        }
        return super.as(targetType);
    }

    public ArrayList<FlowElement> getObjects() {
        return this.objects;
    }

    private void normalizeSequenceFlows(Collection<FlowElement> normalizedObjects) {
        Sequence<FlowNode> allActivities = ModelObjectSelection.getAllActivities(normalizedObjects);
        Sequence<SequenceFlow> seqFlows = this.getTransitions(normalizedObjects);
        for (SequenceFlow seqFlow : seqFlows) {
            if (!allActivities.contains(seqFlow.getSource())) continue;
            normalizedObjects.remove(seqFlow);
        }
    }

    private void normalizeMeasurements(Collection<FlowElement> normalizedObjects) {
        Sequence<Measurement> allMeasurements = this.getAllMeasurements(normalizedObjects);
        Sequence<SequenceFlow> seqFlows = this.getTransitions(normalizedObjects);
        for (Measurement measurement : allMeasurements) {
            if (!seqFlows.contains(measurement.getTransition()) && !ModelObjectSelection.getAllActivities(normalizedObjects).contains(measurement.getTransition().getSource())) continue;
            normalizedObjects.remove(measurement);
        }
    }

    private void normalizeBoundedEvents(Collection<FlowElement> normalizedObjects) {
        Sequence<BoundaryEvent> boundaries = CollectionUtils.selectInstanceOf(CollectionUtils.asSequence(normalizedObjects), BoundaryEvent.class);
        ArrayList<BoundaryEvent> toBeDeleted = new ArrayList<BoundaryEvent>();
        for (BoundaryEvent event : boundaries) {
            Activity activity = event.getBoundaryActivity();
            if (activity == null || !normalizedObjects.contains(activity)) continue;
            toBeDeleted.add(event);
        }
        for (BoundaryEvent event : toBeDeleted) {
            normalizedObjects.remove(event);
        }
    }

    private Sequence<Measurement> getAllMeasurements(Collection<FlowElement> normalizedObjects) {
        return CollectionUtils.selectInstanceOf(CollectionUtils.asSequence(new ArrayList<FlowElement>(normalizedObjects)), Measurement.class);
    }

    private Sequence<TextAnnotation> getAllTextAnnotations() {
        return CollectionUtils.selectInstanceOf(CollectionUtils.asSequence(new ArrayList<FlowElement>(this.objects)), TextAnnotation.class);
    }

    private void addTransitions() {
        for (FlowNode flowNode : this.getActivities()) {
            for (SequenceFlow incoming : flowNode.getIncomingSequenceFlows()) {
                if (!this.objects.contains(incoming.getSource())) continue;
                this.addObject((FlowElement)incoming);
            }
            for (SequenceFlow outgoing : flowNode.getOutgoingSequenceFlows()) {
                if (!this.objects.contains(outgoing.getTarget())) continue;
                this.addObject((FlowElement)outgoing);
            }
        }
    }

    private void internalAddObject(FlowElement flowElement) {
        if (!this.objects.contains(flowElement) && flowElement != this) {
            this.objects.add(flowElement);
        }
    }
}

