/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.xpath;

import java.util.Set;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.TypeNormalizer;
import oracle.bpm.compiler.xpath.XPTypeNormalizer;
import oracle.bpm.compiler.xpath.XPathGenerator;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathGeneratorUtils {
    private XPathGeneratorUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FuegoCompiler buildCompiler() {
        FuegoCompiler compiler = new FuegoCompiler();
        compiler.setTypeResolver((TypeNormalizer)new XPTypeNormalizer());
        compiler.setDirective(3);
        FuegoCompiler fuegoCompiler = compiler;
        if (fuegoCompiler == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildCompiler must not return null");
        }
        return fuegoCompiler;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static FuegoCompiler buildCompiler(@NotNull MethodTypeDescription mtd) {
        if (mtd == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildCompiler must not be null");
        }
        FuegoCompiler compiler = XPathGeneratorUtils.buildCompiler();
        compiler.addObjectClass(mtd.getParentRef());
        FuegoCompiler fuegoCompiler = compiler;
        if (fuegoCompiler == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildCompiler must not return null");
        }
        return fuegoCompiler;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull Set<XPathVariable> scope, @NotNull ComponentCatalog catalog) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        MethodTypeDescription methodTypeDescription = XPathGeneratorUtils.buildMethod(scope, catalog, null);
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not return null");
        }
        return methodTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull Set<XPathVariable> scope, @NotNull ComponentCatalog catalog, @Nullable TypeRef resultType) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        MethodTypeDescription methodTypeDescription = XPathGeneratorUtils.buildMethod(scope, catalog, resultType, false);
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not return null");
        }
        return methodTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static MethodTypeDescription buildMethod(@NotNull Set<XPathVariable> scope, @NotNull ComponentCatalog catalog, @Nullable TypeRef resultType, boolean lvalue) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not be null");
        }
        ObjectTypeDescription obj = XPathGeneratorUtils.createObject(scope, catalog);
        MethodTypeDescription mtd = XPathGeneratorUtils.createMethod(resultType, lvalue);
        obj.addMember(mtd);
        MethodTypeDescription methodTypeDescription = mtd;
        if (methodTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.buildMethod must not return null");
        }
        return methodTypeDescription;
    }

    static void setLValue(MethodTypeDescription mtd, @Nullable TypeRef resultType, boolean lvalue) {
        assert (resultType == null || resultType.getKind() != 0) : "resultType cannot be void";
        XPathGeneratorUtils.resetMethod(mtd);
        TypeRef type = XPathGeneratorUtils.notNull(resultType, lvalue);
        if (lvalue) {
            mtd.addModifiers(0x4000000000000L);
            mtd.addArgument(new Argument("value$0", type, 1L));
        } else {
            mtd.setResultType(type);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static TypeRef getGenericType(boolean isLValue) {
        TypeDescription typeDescription = isLValue ? TypeFactory.getNull() : TypeFactory.getAny();
        if (typeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.getGenericType must not return null");
        }
        return typeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static TypeRef notNull(@Nullable TypeRef resultType, boolean lvalue) {
        TypeRef typeRef = resultType != null ? resultType : XPathGeneratorUtils.getGenericType(lvalue);
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/xpath/XPathGeneratorUtils.notNull must not return null");
        }
        return typeRef;
    }

    private static ObjectTypeDescription createObject(Set<XPathVariable> scope, ComponentCatalog catalog) {
        ObjectTypeDescription obj = new ObjectTypeDescription(XPathGenerator.class.getSimpleName());
        obj.setComponentType(ComponentType.XOBJECT.getText());
        obj.setCatalog(catalog);
        obj.addModifier(0x10000000L);
        for (XPathVariable variable : scope) {
            String name = variable.getName();
            TypeRef type = variable.getType();
            if (type.get().isUnknown()) continue;
            long modifiers = 32840L;
            if (!variable.isReadOnly()) {
                modifiers |= 4L;
            }
            obj.addMember(new AttributeTypeDescription(name, type, modifiers));
        }
        return obj;
    }

    private static void resetMethod(MethodTypeDescription mtd) {
        mtd.removeAllArguments();
        mtd.clearModifier(0x4000000000000L);
        mtd.setResultType(TypeFactory.getVoid());
    }

    private static MethodTypeDescription createMethod(TypeRef resultType, boolean lvalue) {
        MethodTypeDescription mtd = new MethodTypeDescription("CIL$_expression", 68753031232L);
        XPathGeneratorUtils.setLValue(mtd, resultType, lvalue);
        return mtd;
    }
}

