/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.impl.svnkit.editor.operation.out;

import com.oracle.subversion.protocol.BytesItem;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import com.oracle.subversion.server.impl.svnkit.editor.operation.EditorOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class TextDeltaChunkOperation
extends EditorOperation {
    private String path;
    private long revision;

    public TextDeltaChunkOperation(String token, String path, long revision) {
        super(token);
        this.path = path;
        this.revision = revision;
    }

    @Override
    public void doExecute(ExecutionContext context) throws MessageEncodingException {
        InputStream target = null;
        InputStream source = null;
        try {
            Long targetRevision = (Long)context.getVariable("targetRevision");
            target = SVNKitHelper.getTmpInputStream(context.getRepository(), this.path, targetRevision);
            if (this.revision > 0L) {
                source = SVNKitHelper.getTmpInputStream(context.getRepository(), this.path, this.revision);
            }
            SVNDeltaGenerator generator = new SVNDeltaGenerator();
            final TextChunkOutputStream _out = new TextChunkOutputStream(context.getOutputStream());
            String md5 = generator.sendDelta(this.path, source == null ? SVNFileUtil.DUMMY_IN : source, 0L, target, new ISVNDeltaConsumer(){
                boolean writeHeader = true;

                public void applyTextDelta(String s, String s1) throws SVNException {
                }

                public OutputStream textDeltaChunk(String s, SVNDiffWindow diffWindow) throws SVNException {
                    try {
                        diffWindow.writeTo(_out, this.writeHeader, true);
                    }
                    catch (IOException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR), (Throwable)e);
                    }
                    this.writeHeader = false;
                    return null;
                }

                public void textDeltaEnd(String s) throws SVNException {
                }
            }, true);
            context.setVariable("currentMd5", md5);
        }
        catch (IOException e) {
            throw new MessageEncodingException(e);
        }
        catch (SVNException e) {
            throw new MessageEncodingException(e);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {}
            }
            if (target != null) {
                try {
                    target.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private class TextChunkOutputStream
    extends OutputStream {
        private OutputStream out;

        public TextChunkOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] _bytes, int _offset, int _len) throws IOException {
            ListItem res = new ListItem();
            res.add(new WordItem("textdelta-chunk"));
            ListItem args = new ListItem();
            args.add(TextDeltaChunkOperation.this.getToken());
            args.add(new BytesItem(_bytes, _len, _offset));
            res.add(args);
            try {
                SvnMessageEncoding.serialize(this.out, res);
            }
            catch (MessageEncodingException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] _bytes) throws IOException {
            this.write(_bytes, 0, _bytes.length);
        }

        @Override
        public void write(int _byte) throws IOException {
            this.write(new byte[]{(byte)(_byte & 0xFF)});
        }
    }
}

