/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.impl.svnkit.editor.operation.out;

import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.editor.operation.EditorOperation;

public final class OpenDirOperation
extends EditorOperation {
    private String path;
    private long revision;

    public OpenDirOperation(String token, String path, long revision) {
        super(token);
        this.path = path;
        this.revision = revision;
    }

    @Override
    public void doExecute(ExecutionContext context) throws MessageEncodingException {
        ListItem res = new ListItem();
        res.add(new WordItem("open-dir"));
        ListItem args = new ListItem();
        args.add(this.path);
        String parentToken = context.peekToken();
        args.add(parentToken);
        String token = this.getToken();
        context.pushToken(token);
        args.add(token);
        ListItem value = new ListItem();
        value.add(this.revision);
        args.add(value);
        res.add(args);
        SvnMessageEncoding.serialize(context.getOutputStream(), res);
    }
}

