/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.impl.svnkit.editor.operation.in;

import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.impl.svnkit.editor.operation.EditorOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

public class TextDeltaChunkOperation
extends EditorOperation {
    private String path;

    public TextDeltaChunkOperation(String token, String path) {
        super(token);
        this.path = path;
    }

    @Override
    public void doExecute(ExecutionContext context) throws SVNException, ExecutionException {
        ISVNEditor commitEditor = (ISVNEditor)context.getVariable("commitEditor");
        Map outTmpFile = (Map)context.getVariable("outputTmpFiles");
        File file = (File)outTmpFile.get(this.getToken());
        try {
            FileInputStream in = new FileInputStream(file);
            context.setVariable("currentOpenFile", in);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            deltaGenerator.sendDelta(this.path, (InputStream)in, (ISVNDeltaConsumer)commitEditor, true);
        }
        catch (FileNotFoundException e) {
            throw new ExecutionException(e);
        }
    }
}

