/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.impl.svnkit.editor.operation;

import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

public abstract class EditorOperation {
    private String token;

    public EditorOperation() {
    }

    public EditorOperation(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void execute(ExecutionContext context) throws MessageEncodingException, ExecutionException {
        try {
            this.doExecute(context);
        }
        catch (SVNException e) {
            ListItem errors = new ListItem();
            ListItem error = new ListItem();
            SVNErrorMessage errorMessage = e.getErrorMessage();
            error.add(errorMessage.getType());
            error.add(errorMessage.getFullMessage());
            error.add("");
            error.add(0);
            errors.add(error);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            throw new ExecutionException(e);
        }
        catch (MessageEncodingException e) {
            throw new ExecutionException(e);
        }
    }

    protected abstract void doExecute(ExecutionContext var1) throws ExecutionException, SVNException, MessageEncodingException;
}

