/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.impl.svnkit;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.encoding.ErrorItemBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.server.command.report.DeletePathReportInfo;
import com.oracle.subversion.server.command.report.LinkPathReportInfo;
import com.oracle.subversion.server.command.report.ReportInfo;
import com.oracle.subversion.server.command.report.ReportInfoType;
import com.oracle.subversion.server.command.report.SetPathReportInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;

public final class SVNKitHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getTmpInputStream(SVNRepository repository, String path, long revision) throws IOException, SVNException {
        File temp = File.createTempFile("SVN", ".temp");
        FileOutputStream outTmpFile = null;
        try {
            outTmpFile = new FileOutputStream(temp);
            repository.getFile(path, revision, null, (OutputStream)outTmpFile);
        }
        finally {
            if (outTmpFile != null) {
                outTmpFile.flush();
                ((OutputStream)outTmpFile).close();
            }
        }
        return new FileInputStream(temp);
    }

    public static void reparent(SVNRepository repository, String svnUri) throws SVNException, URISyntaxException {
        URI uri = new URI(svnUri);
        String path = "".equals(uri.getPath()) ? File.separator : uri.getPath();
        String location = path.substring(repository.getRepositoryPath(null).length());
        SVNURL location1 = repository.getRepositoryRoot(true);
        location1 = location1.appendPath(location, true);
        repository.setLocation(location1, false);
    }

    public static void status(ISVNEditor editor, SVNDepth depth, long revNumber, String target, boolean recurse, SVNRepository repository, List<ReportInfo> reportInfos) throws SVNException {
        DefaultReporterBaton isvnReporterBaton = new DefaultReporterBaton(reportInfos);
        if (depth != null) {
            repository.status(revNumber, target, depth, (ISVNReporterBaton)isvnReporterBaton, editor);
        } else {
            repository.status(revNumber, target, recurse, (ISVNReporterBaton)isvnReporterBaton, editor);
        }
    }

    public static void diff(ISVNEditor editor, SVNDepth depth, long revNumber, String target, boolean textDeltas, boolean ignoreAncestry, SVNURL url, SVNRepository repository, List<ReportInfo> reportInfos) throws SVNException {
        DefaultReporterBaton isvnReporterBaton = new DefaultReporterBaton(reportInfos);
        repository.diff(url, revNumber, -1L, target, ignoreAncestry, depth, textDeltas, (ISVNReporterBaton)isvnReporterBaton, editor);
    }

    public static List<Item> lock(SVNRepository repository, Map<String, Long> map, String comment, boolean stealLock) throws SVNException {
        LockHandler handler = new LockHandler();
        repository.lock(map, comment, stealLock, (ISVNLockHandler)handler);
        return handler.getItems();
    }

    public static List<Item> unlock(SVNRepository repository, Map<String, String> map, boolean breakLock) throws SVNException {
        LockHandler handler = new LockHandler();
        repository.unlock(map, breakLock, (ISVNLockHandler)handler);
        return handler.getItems();
    }

    private static ListItem createLockInfoItem(SVNLock lock) {
        ListItem lockInfo = new ListItem();
        lockInfo.add(lock.getPath());
        lockInfo.add(lock.getID());
        lockInfo.add(lock.getOwner());
        ListItem list = new ListItem();
        if (lock.getComment() != null) {
            list.add(lock.getComment());
        }
        lockInfo.add(list);
        lockInfo.add(lock.getCreationDate());
        list = new ListItem();
        if (lock.getExpirationDate() != null) {
            list.add(lock.getExpirationDate());
        }
        lockInfo.add(list);
        return lockInfo;
    }

    private static final class LockHandler
    implements ISVNLockHandler {
        private List<Item> items = new ArrayList<Item>();

        private LockHandler() {
        }

        public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            Item info;
            if (error != null) {
                ListItem errors = new ListItem();
                Item erroItem = ErrorItemBuilder.buildError((long)error.getErrorCode().getCode(), path, 0L, error.getFullMessage());
                errors.add(erroItem);
                info = SvnMessageBuilder.buildFailure(errors);
            } else {
                ListItem lockInfo = SVNKitHelper.createLockInfoItem(lock);
                info = SvnMessageBuilder.buildSuccess(lockInfo);
            }
            this.items.add(info);
        }

        public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
            Item info;
            if (error != null) {
                ListItem errors = new ListItem();
                Item erroItem = ErrorItemBuilder.buildError((long)error.getErrorCode().getCode(), path, 0L, error.getFullMessage());
                errors.add(erroItem);
                info = SvnMessageBuilder.buildFailure(errors);
            } else {
                ListItem lst = new ListItem();
                lst.add(lock.getPath());
                info = SvnMessageBuilder.buildSuccess(lst);
            }
            this.items.add(info);
        }

        List<Item> getItems() {
            return this.items;
        }
    }

    private static final class DefaultReporterBaton
    implements ISVNReporterBaton {
        private List<ReportInfo> reportInfos;

        public DefaultReporterBaton(List<ReportInfo> reportInfos) {
            this.reportInfos = reportInfos;
        }

        public void report(ISVNReporter isvnReporter) throws SVNException {
            for (ReportInfo reportInfo : this.reportInfos) {
                ReportInfoType type = reportInfo.getType();
                switch (type) {
                    case SET: {
                        SetPathReportInfo spri = (SetPathReportInfo)reportInfo;
                        isvnReporter.setPath(spri.getPath(), spri.getLockToken(), spri.getRevNumber(), SVNDepth.fromString((String)spri.getDepth()), spri.isStartEmpty());
                        break;
                    }
                    case DELETE: {
                        DeletePathReportInfo dpri = (DeletePathReportInfo)reportInfo;
                        isvnReporter.deletePath(dpri.getPath());
                        break;
                    }
                    case LINK: {
                        LinkPathReportInfo linkPathReportInfo = (LinkPathReportInfo)reportInfo;
                    }
                }
            }
            isvnReporter.finishReport();
        }
    }
}

