/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.impl.svnkit;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.ErrorItemBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.CommandProcessor;
import com.oracle.subversion.server.command.Commands;
import com.oracle.subversion.server.command.Condition;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.editor.operation.EditorOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.AbsentDirOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.AbsentFileOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.AddDirOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.AddFileOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.ApplytextDeltaOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.ChangeDirPropertyOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.ChangeFilePropertyOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.CloseDirOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.CloseFileOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.DeleteEntryOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.FileEditorOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.OpenDirOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.OpenFileOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.OpenRootOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.TargetRevisionOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.TextDeltaChunkOperation;
import com.oracle.subversion.server.impl.svnkit.editor.operation.out.TextDeltaEndOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class SVNEditorCommandSet
implements ISVNEditor {
    private List<EditorOperation> operations = new ArrayList<EditorOperation>();
    private SVNRepository repository;
    private Stack<EditorOperation> stack = new Stack();
    private TokenGenerator tokenGenerator = new TokenGenerator();

    public SVNEditorCommandSet(SVNRepository repository) {
        this.repository = repository;
    }

    public void targetRevision(long revision) throws SVNException {
        this.operations.add(new TargetRevisionOperation(revision));
    }

    public void openRoot(long revision) throws SVNException {
        String nextToken = this.tokenGenerator.getNextToken(false);
        OpenRootOperation operation = new OpenRootOperation(revision, nextToken);
        this.operations.add(operation);
        this.stack.push(operation);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        DeleteEntryOperation operation = new DeleteEntryOperation(null, path, revision);
        this.operations.add(operation);
        this.stack.push(operation);
    }

    public void absentDir(String path) throws SVNException {
        this.operations.add(new AbsentDirOperation(path, null));
    }

    public void absentFile(String path) throws SVNException {
        this.operations.add(new AbsentFileOperation(path));
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String nextToken = this.tokenGenerator.getNextToken(false);
        AddDirOperation operation = new AddDirOperation(nextToken, path);
        this.operations.add(operation);
        this.stack.push(operation);
    }

    public void openDir(String path, long revision) throws SVNException {
        String nextToken = this.tokenGenerator.getNextToken(false);
        OpenDirOperation operation = new OpenDirOperation(nextToken, path, revision);
        this.operations.add(operation);
        this.stack.push(operation);
    }

    public void changeDirProperty(String name, SVNPropertyValue svnPropertyValue) throws SVNException {
        EditorOperation peek = this.stack.peek();
        this.operations.add(new ChangeDirPropertyOperation(peek.getToken(), name, svnPropertyValue));
    }

    public void closeDir() throws SVNException {
        EditorOperation operation = this.stack.pop();
        this.operations.add(new CloseDirOperation(operation.getToken()));
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String nextToken = this.tokenGenerator.getNextToken(true);
        AddFileOperation operation = new AddFileOperation(nextToken, path, copyFromRevision);
        this.operations.add(operation);
        this.stack.push(operation);
    }

    public void openFile(String path, long revision) throws SVNException {
        String nextToken = this.tokenGenerator.getNextToken(true);
        OpenFileOperation operation = new OpenFileOperation(nextToken, path, revision);
        this.operations.add(operation);
        this.stack.push(operation);
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue svnPropertyValue) throws SVNException {
        EditorOperation peek = this.stack.peek();
        ChangeFilePropertyOperation operation = new ChangeFilePropertyOperation(peek.getToken(), propertyName, svnPropertyValue);
        this.operations.add(operation);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        FileEditorOperation fileEditorOperation = (FileEditorOperation)this.stack.pop();
        this.operations.add(new CloseFileOperation(fileEditorOperation.getToken()));
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void applyTextDelta(String path, String checksum) throws SVNException {
        FileEditorOperation fileEditorOperation = (FileEditorOperation)this.stack.peek();
        fileEditorOperation.setMd5(checksum);
        this.operations.add(new ApplytextDeltaOperation(fileEditorOperation.getToken(), checksum));
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow svnDiffWindow) throws SVNException {
        FileEditorOperation fileEditorOperation = (FileEditorOperation)this.stack.peek();
        String token = fileEditorOperation.getToken();
        long revision = fileEditorOperation.getRevision();
        this.operations.add(new TextDeltaChunkOperation(token, path, revision));
        return null;
    }

    public void textDeltaEnd(String path) throws SVNException {
        EditorOperation operation = this.stack.peek();
        this.operations.add(new TextDeltaEndOperation(operation.getToken()));
    }

    public void processServerSideEditorCommands(ExecutionContext context) throws MessageEncodingException, ExecutionException {
        OutputStream originOut = context.getOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        context.setOutputStream(out);
        for (EditorOperation operation : this.operations) {
            operation.execute(context);
        }
        ListItem params = new ListItem();
        ListItem res = new ListItem();
        res.add(new WordItem(Keyword.CLOSE_EDIT));
        res.add(params);
        SvnMessageEncoding.serialize(out, res);
        try {
            context.setOutputStream(originOut);
            originOut.write(out.toByteArray(), 0, out.size());
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    public SVNCommitInfo processClientSideEditorCommands(ExecutionContext context, Map<String, String> revProps, String message, ListItem lockInfoItem, boolean keepLocks) throws ExecutionException, MessageEncodingException, SVNException {
        try {
            InputStream inputStream = context.getInputStream();
            context.push(this.operations);
            context.setVariable("openFiles", new HashMap());
            context.setVariable("outputTmpFiles", new HashMap());
            context.setVariable("outputTmpStreams", new HashMap());
            context.setVariable("tokenToPath", new HashMap());
            context.setVariable("openPaths", new ArrayList());
            boolean process = CommandProcessor.process(inputStream, Commands.MAIN_CMD_SET, context, new Condition(){

                @Override
                public boolean finish(Item item) {
                    return item.getValue().equals(Keyword.CLOSE_EDIT.getCode());
                }

                @Override
                public boolean fail(Item item) {
                    return item.getValue().equals(Keyword.ABORT_EDIT.getCode());
                }
            });
            context.pop();
            ISVNEditor commitEditor = null;
            boolean wasOk = false;
            if (!process) {
                ListItem errors = new ListItem();
                errors.add(ErrorItemBuilder.buildError(0L, "", 0L, ""));
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            } else {
                commitEditor = this.repository.getCommitEditor(message, revProps, keepLocks, SVNProperties.wrap(revProps), null);
                context.setVariable("commitEditor", commitEditor);
                for (EditorOperation operation : this.operations) {
                    operation.execute(context);
                }
                wasOk = true;
            }
            context.removeVariable("openFiles");
            context.removeVariable("outputTmpFiles");
            context.removeVariable("outputTmpStreams");
            context.removeVariable("tokenToPath");
            context.removeVariable("openPaths");
            if (wasOk) {
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildEmptySuccess());
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
                SVNCommitInfo commit = commitEditor.closeEdit();
                ListItem res = new ListItem();
                ListItem authorL = new ListItem();
                authorL.add(new StringItem(commit.getAuthor()));
                ListItem date = new ListItem();
                date.add(commit.getDate());
                ListItem args = new ListItem();
                res.add(new NumberItem(commit.getNewRevision()));
                res.add(date);
                res.add(authorL);
                res.add(args);
                SvnMessageEncoding.serialize(context.getOutputStream(), res);
            }
        }
        catch (Exception e) {
            ListItem abortEdit = new ListItem();
            abortEdit.add(Keyword.ABORT_EDIT);
            abortEdit.add(new ListItem());
            SvnMessageEncoding.serialize(context.getOutputStream(), abortEdit);
            ListItem errors = new ListItem();
            errors.add(ErrorItemBuilder.buildError(e));
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            throw new ExecutionException(e);
        }
        finally {
            context.removeVariable("tokenToPath");
        }
        return null;
    }

    private class TokenGenerator {
        private int tokenCount = 0;

        private TokenGenerator() {
        }

        String getNextToken(boolean isFile) {
            String prefix = isFile ? "f" : "d";
            return prefix + this.tokenCount++;
        }
    }
}

