/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command.report;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ItemType;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.command.report.SetPathReportInfo;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.util.List;

public class SetPathCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        List reportInfos = (List)context.pop();
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        StringItem pathItem = (StringItem)value.get(0);
        String path = pathItem.getValue();
        NumberItem revItem = (NumberItem)value.get(1);
        long revNumber = revItem.getValue();
        WordItem emptyItem = (WordItem)value.get(2);
        boolean isEmpty = Boolean.parseBoolean(emptyItem.getValue());
        String lockToken = null;
        String depth = null;
        if (value.size() > 3) {
            Item item = (Item)value.get(3);
            if (item.getType() == ItemType.STRING) {
                StringItem lockTokenItem = (StringItem)item;
                lockToken = lockTokenItem.getValue();
            } else if (item.getType() == ItemType.WORD) {
                WordItem depthItem = (WordItem)value.get(4);
                depth = depthItem.getValue();
            }
        }
        if (value.size() > 4) {
            WordItem depthItem = (WordItem)value.get(4);
            depth = depthItem.getValue();
        }
        reportInfos.add(new SetPathReportInfo(path, revNumber, isEmpty, lockToken, depth));
        context.push(reportInfos);
    }
}

