/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command.editor;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.editor.operation.in.TextDeltaChunkOperation;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;

public class TextDeltaChunkCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        List operations = (List)context.peek();
        Object value = ((ListItem)parameters).getValue();
        StringItem token = (StringItem)value.get(0);
        StringItem bytesItem = (StringItem)value.get(1);
        Map tokenToPath = (Map)context.getVariable("tokenToPath");
        String tokenValue = token.getValue();
        String path = (String)tokenToPath.get(tokenValue);
        SVNDeltaReader deltaReader = (SVNDeltaReader)context.getVariable("deltaReader");
        ISVNDeltaConsumer deltaConsumer = (ISVNDeltaConsumer)context.getVariable("deltaConsumer");
        byte[] bytes = bytesItem.getBytes();
        try {
            deltaReader.nextWindow(bytes, 0, bytes.length, null, deltaConsumer);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
        Object chunked = context.getVariable("chunked");
        if (chunked == null) {
            operations.add(new TextDeltaChunkOperation(tokenValue, path));
            context.setVariable("chunked", new Object());
        }
    }
}

