/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command.editor;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import com.oracle.subversion.server.impl.svnkit.editor.operation.in.OpenFileOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;

public class OpenFileCommand
extends AbstractCommand {
    private String path;
    private long rev;
    private String token;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        List operations = (List)context.peek();
        Map tokenToPath = (Map)context.getVariable("tokenToPath");
        Map openFiles = (Map)context.getVariable("openFiles");
        this.processArguments((ListItem)parameters);
        tokenToPath.put(this.token, this.path);
        context.pushToken(this.token);
        try {
            InputStream tmpInputStream = SVNKitHelper.getTmpInputStream(context.getRepository(), this.path, this.rev);
            operations.add(new OpenFileOperation(this.path, this.rev));
            openFiles.put(this.token, tmpInputStream);
            context.setVariable("openFiles", openFiles);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private void processArguments(ListItem parameters) {
        Object value = parameters.getValue();
        StringItem pathItem = (StringItem)value.get(0);
        StringItem filetokenItem = (StringItem)value.get(2);
        ListItem listItem = (ListItem)value.get(3);
        if (!listItem.getValue().isEmpty()) {
            NumberItem copyRevItem = (NumberItem)listItem.getValue().get(0);
            this.rev = copyRevItem.getValue();
        }
        this.path = pathItem.getValue();
        this.token = filetokenItem.getValue();
    }
}

