/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command.editor;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.editor.operation.in.ApplytextDeltaOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class ApplyTextDeltaCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        List operations = (List)context.peek();
        Object value = ((ListItem)parameters).getValue();
        StringItem token = (StringItem)value.get(0);
        ListItem listItem = (ListItem)value.get(1);
        String md5 = null;
        if (!listItem.getValue().isEmpty()) {
            StringItem item = (StringItem)listItem.getValue().get(0);
            md5 = item.getValue();
        }
        Map tokenToPath = (Map)context.getVariable("tokenToPath");
        String tokenValue = token.getValue();
        String path = (String)tokenToPath.get(tokenValue);
        try {
            File file = File.createTempFile("applyTextDelta" + tokenValue, ".tmp");
            FileOutputStream output = new FileOutputStream(file);
            final SVNDeltaProcessor deltaProcessor = new SVNDeltaProcessor();
            SVNDeltaReader deltaReader = new SVNDeltaReader();
            ISVNDeltaConsumer deltaConsumer = new ISVNDeltaConsumer(){

                public void applyTextDelta(String _path, String _baseChecksum) {
                }

                public OutputStream textDeltaChunk(String _path, SVNDiffWindow _svndiffwindow) throws SVNException {
                    return deltaProcessor.textDeltaChunk(_svndiffwindow);
                }

                public void textDeltaEnd(String _path) {
                }
            };
            Map openFiles = (Map)context.getVariable("openFiles");
            InputStream baseInFile = (InputStream)openFiles.get(tokenValue);
            baseInFile = baseInFile == null ? SVNFileUtil.DUMMY_IN : baseInFile;
            openFiles.put(tokenValue, baseInFile);
            deltaProcessor.applyTextDelta(baseInFile, (OutputStream)output, true);
            Map outTmpFile = (Map)context.getVariable("outputTmpFiles");
            Map outTmpStream = (Map)context.getVariable("outputTmpStreams");
            outTmpFile.put(tokenValue, file);
            outTmpStream.put(tokenValue, output);
            context.setVariable("deltaReader", deltaReader);
            context.setVariable("deltaConsumer", deltaConsumer);
            context.setVariable("deltaProcessor", deltaProcessor);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        operations.add(new ApplytextDeltaOperation(path, md5));
    }
}

