/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command.editor;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.editor.operation.in.AddFileOperation;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class AddFileCommand
extends AbstractCommand {
    private String copyPath;
    private long copyRev = -1L;
    private String path;
    private String token;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.processArguments((ListItem)parameters);
        Map tokenToPath = (Map)context.getVariable("tokenToPath");
        List operations = (List)context.peek();
        Map openFiles = (Map)context.getVariable("openFiles");
        tokenToPath.put(this.token, this.path);
        InputStream tmpInputStream = SVNFileUtil.DUMMY_IN;
        operations.add(new AddFileOperation(this.path, this.copyPath, this.copyRev));
        openFiles.put(this.token, tmpInputStream);
        context.pushToken(this.token);
        context.setVariable("openFiles", openFiles);
    }

    private void processArguments(ListItem parameters) {
        Object value = parameters.getValue();
        StringItem pathItem = (StringItem)value.get(0);
        StringItem filetokenItem = (StringItem)value.get(2);
        ListItem listItem = (ListItem)value.get(3);
        if (!listItem.getValue().isEmpty()) {
            StringItem copyPathItem = (StringItem)listItem.getValue().get(0);
            this.copyPath = copyPathItem.getValue();
            NumberItem copyRevItem = (NumberItem)listItem.getValue().get(1);
            this.copyRev = copyRevItem.getValue();
        }
        this.path = pathItem.getValue();
        this.token = filetokenItem.getValue();
    }
}

