/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command.editor;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.editor.operation.in.AddDirOperation;
import com.oracle.subversion.server.util.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class AddDirCommand
extends AbstractCommand {
    private String childtoken;
    private String copyPath;
    private long copyRev;
    private String parentToken;
    private String path;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        this.processParameters((ListItem)parameters);
        List operations = (List)context.peek();
        Map tokenToPath = (Map)context.getVariable("tokenToPath");
        List openPaths = (List)context.getVariable("openPaths");
        String parentPath = FileUtil.makePathName(openPaths);
        if (!parentPath.equals(File.separator) && this.path.startsWith(parentPath)) {
            this.path = this.path.substring(parentPath.length());
        }
        tokenToPath.put(this.childtoken, this.path);
        context.pushToken(this.childtoken);
        openPaths.add(this.path);
        String fullPath = this.path;
        if (!context.getVariable("root").equals(parentPath)) {
            fullPath = parentPath + File.separator + fullPath;
        }
        String svnurl = this.getCopyPathUrl();
        operations.add(new AddDirOperation(fullPath, svnurl, this.copyRev));
    }

    private String getCopyPathUrl() throws ExecutionException {
        String svnurl = null;
        if (this.copyPath != null) {
            try {
                svnurl = SVNURL.parseURIDecoded((String)this.copyPath).getPath();
            }
            catch (SVNException e) {
                throw new ExecutionException(e);
            }
        }
        return svnurl;
    }

    private void processParameters(ListItem parameters) {
        ListItem item;
        Object itemList;
        Object value = parameters.getValue();
        StringItem pathItem = (StringItem)value.get(0);
        StringItem parentTokenItem = (StringItem)value.get(1);
        StringItem newDirtokenItem = (StringItem)value.get(2);
        if (value.size() > 3 && !(itemList = (item = (ListItem)value.get(3)).getValue()).isEmpty()) {
            StringItem copyPathItem = (StringItem)itemList.get(0);
            NumberItem copyRevItem = (NumberItem)itemList.get(1);
            this.copyPath = copyPathItem.getValue();
            this.copyRev = copyRevItem.getValue();
        }
        this.path = pathItem.getValue();
        this.childtoken = newDirtokenItem.getValue();
        this.parentToken = parentTokenItem.getValue();
    }
}

