/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.security.sasl.OpssCallbackHandler;
import com.oracle.subversion.security.sasl.PlainSaslSecurityProvider;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public final class SvnAuthenticator {
    public static ListItem authenticate(ExecutionContext context) throws MessageEncodingException, SaslException, ExecutionException {
        ListItem authreq = new ListItem();
        ListItem mechanism = new ListItem();
        mechanism.add(new WordItem("PLAIN"));
        authreq.add(mechanism);
        authreq.add("localhost");
        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildSuccess(authreq));
        byte[] challenge = SvnAuthenticator.doAuthenticate(context);
        ListItem res = new ListItem();
        mechanism.add(new StringItem(challenge));
        return res;
    }

    private static byte[] doAuthenticate(ExecutionContext context) throws MessageEncodingException, SaslException, ExecutionException {
        ListItem res = (ListItem)SvnMessageEncoding.deserialize(context.getInputStream());
        Object value = res.getValue();
        if (value.isEmpty()) {
            throw new ExecutionException("Client auth response is null");
        }
        WordItem clientMech = (WordItem)value.get(0);
        if (!"PLAIN".equals(clientMech.getValue())) {
            throw new ExecutionException("Sasl Mechanism not supported:" + clientMech.getValue());
        }
        ListItem authToken = (ListItem)value.get(1);
        StringItem clientToken = (StringItem)authToken.getValue().get(0);
        byte[] clientTokenBytes = clientToken.getBytes();
        OpssCallbackHandler handler = new OpssCallbackHandler();
        SaslServer saslServer = SvnAuthenticator.createSaslServer("localhost", handler);
        byte[] response = clientTokenBytes == null ? new byte[]{} : clientTokenBytes;
        byte[] challenge = saslServer.evaluateResponse(response);
        while (!saslServer.isComplete()) {
            ListItem stepInfo = new ListItem();
            stepInfo.add(new StringItem(challenge));
            ListItem stepRes = new ListItem();
            stepRes.add(new WordItem(Keyword.STEP));
            stepRes.add(stepInfo);
            SvnMessageEncoding.serialize(context.getOutputStream(), stepRes);
            StringItem resItem = (StringItem)SvnMessageEncoding.deserialize(context.getInputStream());
            response = resItem.getBytes();
            challenge = saslServer.evaluateResponse(response);
        }
        return challenge == null ? new byte[]{} : challenge;
    }

    private static SaslServer createSaslServer(String hostname, CallbackHandler handler) throws SaslException {
        Security.addProvider(new PlainSaslSecurityProvider());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.security.sasl.qop", "auth, auth-int, auth-conf");
        props.put("javax.security.sasl.policy.noanonymous", "true");
        props.put("javax.security.sasl.policy.noplaintext", "false");
        props.put("javax.security.sasl.reuse", "false");
        return Sasl.createSaslServer("PLAIN", "svn", hostname, props, handler);
    }
}

