/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.ErrorItemBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.command.report.ReportCommandHelper;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNEditorCommandSet;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import java.util.List;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class StatusCommand
extends AbstractCommand {
    private SVNDepth depth;
    private boolean recurse;
    private long revNumber = -1L;
    private String target;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.processParameters(parameters);
        try {
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            boolean success = ReportCommandHelper.readReportInfo(context);
            if (!success) {
                ListItem errors = new ListItem();
                errors.add(ErrorItemBuilder.buildError(0L, "", 0L, "Report Info processing fail"));
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            } else {
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
                Object pop = context.pop();
                if (pop == null) {
                    ListItem errors = new ListItem();
                    errors.add(ErrorItemBuilder.buildError(0L, "", 0L, "Failed getting Report Info List"));
                    SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
                } else {
                    List reportInfos = (List)pop;
                    SVNRepository repository = context.getRepository();
                    SVNEditorCommandSet editor = new SVNEditorCommandSet(repository);
                    SVNKitHelper.status(editor, this.depth, this.revNumber, this.target, this.recurse, repository, reportInfos);
                    editor.processServerSideEditorCommands(context);
                    Item response = SvnMessageEncoding.deserialize(context.getInputStream());
                    ListItem params = new ListItem();
                    params.add(new ListItem());
                    ListItem res = new ListItem();
                    res.add(Keyword.SUCESS);
                    res.add(params);
                    SvnMessageEncoding.serialize(context.getOutputStream(), res);
                }
            }
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private void processParameters(Item parameters) throws ExecutionException {
        this.assertArgumentListType(parameters);
        Object value = ((ListItem)parameters).getValue();
        StringItem targetItem = (StringItem)value.get(0);
        this.target = targetItem.getValue();
        WordItem recurseItem = (WordItem)value.get(1);
        this.recurse = Boolean.parseBoolean(recurseItem.getValue());
        this.revNumber = -1L;
        ListItem revItem = (ListItem)value.get(2);
        Object revValue = revItem.getValue();
        if (revValue.size() > 0) {
            NumberItem item = (NumberItem)revValue.get(0);
            this.revNumber = item.getValue();
        }
        WordItem depthItem = (WordItem)value.get(3);
        this.depth = SVNDepth.fromString((String)depthItem.getValue());
    }
}

