/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;

public class RevPropListCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        NumberItem numberItem = (NumberItem)value.get(0);
        long revision = numberItem.getValue();
        try {
            SVNProperties revisionProperties = context.getRepository().getRevisionProperties(revision, null);
            ListItem item = new ListItem();
            Set set = revisionProperties.nameSet();
            for (String name : set) {
                ListItem prop = new ListItem();
                prop.add(name);
                prop.add(revisionProperties.getSVNPropertyValue(name).getString());
                item.add(prop);
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), item);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }
}

