/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.io.SVNRepository;

public class RevPropCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        NumberItem numberItem = (NumberItem)value.get(0);
        StringItem stringItem = (StringItem)value.get(1);
        long revision = numberItem.getValue();
        String name = stringItem.getValue();
        SVNRepository repository = context.getRepository();
        try {
            SVNPropertyValue revisionPropertyValue = repository.getRevisionPropertyValue(revision, name);
            ListItem item = new ListItem();
            item.add(revisionPropertyValue.getString());
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildSuccess(item));
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }
}

