/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import java.net.URISyntaxException;
import org.tmatesoft.svn.core.SVNException;

public class ReparentCommand
extends AbstractCommand {
    @Override
    public void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        ListItem params = (ListItem)parameters;
        Object value = params.getValue();
        StringItem item = (StringItem)value.get(0);
        String svnUri = item.getValue();
        try {
            SVNKitHelper.reparent(context.getRepository(), svnUri);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(e);
        }
        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
        ListItem res = new ListItem();
        res.add(Keyword.SUCESS);
        res.add(new ListItem());
        SvnMessageEncoding.serialize(context.getOutputStream(), res);
    }
}

