/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;

public class LogCommand
extends AbstractCommand {
    private boolean changePath;
    private long endRev;
    private long limitNumber;
    private boolean revpropEnabled;
    private long startRev;
    private boolean strictNode;
    private String[] targetPaths;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.processArguments(parameters);
        ArrayList<SVNLogEntry> ex = new ArrayList<SVNLogEntry>();
        LogEntryHandler handler = new LogEntryHandler(this.revpropEnabled, context, ex);
        try {
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            context.getRepository().log(this.targetPaths, this.startRev, this.endRev, this.changePath, this.strictNode, this.limitNumber, (ISVNLogEntryHandler)handler);
            ListItem res = new ListItem();
            res.add(Keyword.SUCESS);
            res.add(new ListItem());
            SvnMessageEncoding.serialize(context.getOutputStream(), new WordItem(Keyword.DONE), res);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private void processArguments(Item parameters) throws ExecutionException {
        this.assertArgumentListType(parameters);
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        ListItem targetsItem = (ListItem)value.get(0);
        ListItem startRevItem = (ListItem)value.get(1);
        ListItem endRevItem = (ListItem)value.get(2);
        WordItem changedPathItem = (WordItem)value.get(3);
        WordItem strictNodeItem = (WordItem)value.get(4);
        NumberItem limitNumberItem = (NumberItem)value.get(5);
        WordItem allRevOrRev = (WordItem)value.get(7);
        this.startRev = ((NumberItem)startRevItem.getValue().get(0)).getValue();
        this.endRev = ((NumberItem)endRevItem.getValue().get(0)).getValue();
        this.changePath = Boolean.valueOf(changedPathItem.getValue());
        this.strictNode = Boolean.valueOf(strictNodeItem.getValue());
        this.limitNumber = limitNumberItem.getValue();
        this.limitNumber = this.limitNumber == 0L ? -1L : this.limitNumber;
        this.revpropEnabled = allRevOrRev.getValue().equals("revprops");
        this.targetPaths = null;
        Object itemList = targetsItem.getValue();
        if (!itemList.isEmpty()) {
            this.targetPaths = new String[itemList.size()];
            int idx = 0;
            Iterator i$ = itemList.iterator();
            while (i$.hasNext()) {
                Item item = (Item)i$.next();
                StringItem si = (StringItem)item;
                this.targetPaths[idx++] = si.getValue();
            }
        }
    }

    private final class LogEntryHandler
    implements ISVNLogEntryHandler {
        private ExecutionContext context;
        private List<SVNLogEntry> entries;
        private boolean revpropEnabled;

        public LogEntryHandler(boolean revpropEnabled, ExecutionContext context, List<SVNLogEntry> e) {
            this.revpropEnabled = revpropEnabled;
            this.context = context;
            this.entries = e;
        }

        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (logEntry.getAuthor() == null) {
                return;
            }
            this.entries.add(logEntry);
            ListItem res = new ListItem();
            ListItem changeReviPathEntries = new ListItem();
            ListItem authorList = new ListItem();
            ListItem dateList = new ListItem();
            ListItem msgList = new ListItem();
            ListItem props = new ListItem();
            authorList.add(logEntry.getAuthor());
            dateList.add(logEntry.getDate());
            msgList.add(logEntry.getMessage());
            SVNProperties revisionProperties = logEntry.getRevisionProperties();
            int size = 0;
            ArrayList<String> excludedSVNProp = new ArrayList<String>();
            excludedSVNProp.add("svn:log");
            excludedSVNProp.add("svn:author");
            excludedSVNProp.add("svn:date");
            if (revisionProperties != null) {
                size = revisionProperties.size();
                Set set = revisionProperties.nameSet();
                for (Object o : set) {
                    if (this.revpropEnabled && excludedSVNProp.contains(o)) continue;
                }
            }
            if (LogCommand.this.changePath) {
                this.addChangePathItems(logEntry, changeReviPathEntries);
            }
            res.add(changeReviPathEntries);
            res.add(new NumberItem(logEntry.getRevision()));
            res.add(authorList);
            res.add(dateList);
            res.add(msgList);
            res.add(new WordItem(Boolean.toString(logEntry.hasChildren())));
            res.add(new WordItem("false"));
            res.add(size);
            res.add(props);
            try {
                SvnMessageEncoding.serialize(this.context.getOutputStream(), res);
            }
            catch (MessageEncodingException e) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e));
            }
        }

        private void addChangePathItems(SVNLogEntry logEntry, ListItem changeReviPathEntries) {
            Map changedPaths = logEntry.getChangedPaths();
            Set keys = changedPaths.keySet();
            for (String key : keys) {
                SVNLogEntryPath svnLogEntryPath = (SVNLogEntryPath)changedPaths.get(key);
                ListItem changePathEntry = new ListItem();
                changePathEntry.add(svnLogEntryPath.getPath());
                changePathEntry.add(new WordItem(String.valueOf(svnLogEntryPath.getType())));
                ListItem revisionLog = new ListItem();
                if (svnLogEntryPath.getCopyPath() != null) {
                    revisionLog.add(svnLogEntryPath.getCopyPath());
                    revisionLog.add(svnLogEntryPath.getCopyRevision());
                }
                ListItem extraLog = new ListItem();
                SVNNodeKind kind = svnLogEntryPath.getKind();
                extraLog.add(kind.toString());
                changePathEntry.add(revisionLog);
                changePathEntry.add(extraLog);
                changeReviPathEntries.add(changePathEntry);
            }
        }
    }
}

