/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.command.SvnAuthenticator;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslException;
import org.tmatesoft.svn.core.SVNException;

public class LockManyCommand
extends AbstractCommand {
    protected String comment;
    protected Map<String, Long> locks = new HashMap<String, Long>();
    protected boolean stealLock;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.processArguments(parameters);
        this.doLock(context);
    }

    protected void doLock(ExecutionContext context) throws ExecutionException {
        try {
            Item[] serItems;
            List<Item> items = SVNKitHelper.lock(context.getRepository(), this.locks, this.comment, this.stealLock);
            ListItem authenticate = SvnAuthenticator.authenticate(context);
            ArrayList<Item> itemsToSend = new ArrayList<Item>();
            itemsToSend.add(SvnMessageBuilder.buildSuccess(authenticate));
            itemsToSend.addAll(items);
            itemsToSend.add(new WordItem(Keyword.DONE));
            itemsToSend.add(SvnMessageBuilder.buildEmptySuccess());
            for (Item item : serItems = itemsToSend.toArray(new Item[itemsToSend.size()])) {
                SvnMessageEncoding.serialize(context.getOutputStream(), item);
            }
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
        catch (MessageEncodingException e) {
            throw new ExecutionException(e);
        }
        catch (SaslException e) {
            throw new ExecutionException(e);
        }
    }

    private void processArguments(Item parameters) throws ExecutionException {
        this.assertArgumentListType(parameters);
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        ListItem commentItemList = (ListItem)value.get(0);
        Object value1 = commentItemList.getValue();
        if (!value1.isEmpty()) {
            StringItem commentItem = (StringItem)value.get(0);
            this.comment = commentItem.getValue();
        }
        WordItem stealLockItem = (WordItem)value.get(1);
        this.stealLock = Boolean.parseBoolean(stealLockItem.getValue());
        ListItem listitems = (ListItem)value.get(2);
        Iterator i$ = listitems.getValue().iterator();
        while (i$.hasNext()) {
            Item item = (Item)i$.next();
            ListItem itemList = (ListItem)item;
            Object lockItems = itemList.getValue();
            StringItem pathItem = (StringItem)lockItems.get(0);
            ListItem currentRevItemList = (ListItem)lockItems.get(1);
            Object currentRevItemListValue = currentRevItemList.getValue();
            long currentRev = -1L;
            if (!currentRevItemListValue.isEmpty()) {
                currentRev = ((NumberItem)currentRevItemListValue.get(0)).getValue();
            }
            String path = pathItem.getValue();
            this.locks.put(path, currentRev);
        }
    }
}

