/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Capability;
import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import java.net.URI;
import java.net.URISyntaxException;
import org.tmatesoft.svn.core.SVNException;

public class GreetingsCommand
extends AbstractCommand {
    @Override
    public void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        NumberItem versionItem;
        Long versionItemValue;
        ListItem capabilities = new ListItem();
        capabilities.add(Capability.EDIT_PIPELINE);
        capabilities.add(Capability.SVNDIFF1);
        capabilities.add(Capability.ABSENT_ENTRIES);
        capabilities.add(Capability.COMMIT_REVPROPS);
        capabilities.add(Capability.DEPTH);
        capabilities.add(new WordItem("log-revprops"));
        capabilities.add(Capability.EDIT_PIPELINE);
        ListItem params = new ListItem();
        params.add(new WordItem("2"));
        params.add(new WordItem("2"));
        params.add(new ListItem());
        params.add(capabilities);
        ListItem res = new ListItem();
        res.add(Keyword.SUCESS);
        res.add(params);
        SvnMessageEncoding.serialize(context.getOutputStream(), res);
        Item item = SvnMessageEncoding.deserialize(context.getInputStream());
        if (item == null) {
            throw new ExecutionException("");
        }
        ListItem result = (ListItem)item;
        Object value = result.getValue();
        Item protocolVersionItem = (Item)value.get(0);
        StringItem urlItem = (StringItem)value.get(2);
        String url = urlItem.getValue();
        if (protocolVersionItem != null && (versionItemValue = (versionItem = (NumberItem)protocolVersionItem).getValue()) != 2L) {
            throw new ExecutionException("Unsupported subversion protocol version '" + versionItemValue + "'");
        }
        try {
            String path = new URI(url).getPath();
            context.setVariable("root", path);
            SVNKitHelper.reparent(context.getRepository(), url);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(e);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }
}

