/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.io.SVNRepository;

public class GetMergeInfoCommand
extends AbstractCommand {
    private boolean descendents;
    private SVNMergeInfoInheritance inherited;
    private String[] paths;
    private long rev;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.processArguments(parameters);
        try {
            SVNRepository repository = context.getRepository();
            Map mergeInfo = repository.getMergeInfo(this.paths, this.rev, this.inherited, this.descendents);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            Set set = mergeInfo.keySet();
            ListItem res = new ListItem();
            if (set != null && !set.isEmpty()) {
                ListItem info = new ListItem();
                res.add(info);
                for (String key : set) {
                    SVNMergeInfo svnMergeInfo = (SVNMergeInfo)mergeInfo.get(key);
                    String path = svnMergeInfo.getPath();
                    ListItem mergeInfoItem = new ListItem();
                    mergeInfoItem.add(path);
                    Map mergeSourcesToMergeLists = svnMergeInfo.getMergeSourcesToMergeLists();
                    if (!mergeSourcesToMergeLists.isEmpty()) {
                        Set keys = mergeSourcesToMergeLists.keySet();
                        for (String k : keys) {
                            SVNMergeRangeList svnMergeRangeList = (SVNMergeRangeList)mergeSourcesToMergeLists.get(k);
                            List rangesAsList = svnMergeRangeList.getRangesAsList();
                            String range = ((SVNMergeRange)rangesAsList.get(0)).toString();
                            mergeInfoItem.add(k + ":" + range);
                        }
                    }
                    info.add(mergeInfoItem);
                }
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildSuccess(res));
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private void processArguments(Item parameters) throws ExecutionException {
        String inherited;
        this.assertArgumentListType(parameters);
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        ListItem pathItems = (ListItem)value.get(0);
        ListItem revListItem = (ListItem)value.get(1);
        WordItem inheritedItem = (WordItem)value.get(2);
        Object revListItemValue = revListItem.getValue();
        NumberItem revItem = (NumberItem)revListItemValue.get(0);
        if (value.size() > 3) {
            WordItem validateItem = (WordItem)value.get(3);
            this.descendents = Boolean.parseBoolean(validateItem.getValue());
        }
        if ("explicit".equals(inherited = inheritedItem.getValue())) {
            this.inherited = SVNMergeInfoInheritance.EXPLICIT;
        } else if ("inherited".equals(inherited)) {
            this.inherited = SVNMergeInfoInheritance.INHERITED;
        } else if ("nearest-ancestor".equals(inherited)) {
            this.inherited = SVNMergeInfoInheritance.NEAREST_ANCESTOR;
        }
        this.rev = revItem.getValue();
        Object itemList = pathItems.getValue();
        this.paths = new String[itemList.size()];
        int idx = 0;
        Iterator i$ = itemList.iterator();
        while (i$.hasNext()) {
            Item item = (Item)i$.next();
            this.paths[idx++] = ((StringItem)item).getValue();
        }
    }
}

