/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;

public class GetLocksCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        ListItem item = (ListItem)parameters;
        Object itemValue = item.getValue();
        StringItem pathItem = (StringItem)itemValue.get(0);
        String value = pathItem.getValue();
        try {
            SVNLock[] locks = context.getRepository().getLocks(value);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            ListItem locksInfoItems = new ListItem();
            Item res = SvnMessageBuilder.buildSuccess(locksInfoItems);
            if (locks != null && locks.length > 0) {
                for (SVNLock lock : locks) {
                    ListItem lockInfo = new ListItem();
                    locksInfoItems.add(lockInfo);
                    lockInfo.add(lock.getPath());
                    lockInfo.add(lock.getID());
                    lockInfo.add(lock.getOwner());
                    lockInfo.add(lock.getComment());
                    lockInfo.add(lock.getCreationDate());
                    lockInfo.add(lock.getExpirationDate());
                }
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), res);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }
}

