/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;

public class GetLockCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        ListItem item = (ListItem)parameters.getValue();
        Object itemValue = item.getValue();
        StringItem pathItem = (StringItem)itemValue.get(0);
        String value = pathItem.getValue();
        try {
            SVNLock lock = context.getRepository().getLock(value);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            ListItem res = new ListItem();
            ListItem params = new ListItem();
            params.add(new ListItem());
            res.add(Keyword.SUCESS);
            ListItem lockInfo = new ListItem();
            res.add(lockInfo);
            if (lock != null) {
                lockInfo.add(lock.getPath());
                lockInfo.add(lock.getID());
                lockInfo.add(lock.getOwner());
                lockInfo.add(lock.getComment());
                lockInfo.add(lock.getCreationDate());
                lockInfo.add(lock.getExpirationDate());
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), res);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }
}

