/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;

public class GetLocationsCommand
extends AbstractCommand {
    private String path;
    private long pegRev;
    private long[] revisions;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        this.processParameters((ListItem)parameters);
        final ArrayList entries = new ArrayList();
        ISVNLocationEntryHandler handler = new ISVNLocationEntryHandler(){

            public void handleLocationEntry(SVNLocationEntry locationEntry) throws SVNException {
                entries.add(locationEntry);
            }
        };
        try {
            context.getRepository().getLocations(this.path, this.pegRev, this.revisions, handler);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            for (SVNLocationEntry entry : entries) {
                ListItem item = new ListItem();
                item.add(entry.getRevision());
                item.add(entry.getPath());
                SvnMessageEncoding.serialize(context.getOutputStream(), item);
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), new WordItem(Keyword.DONE));
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildEmptySuccess());
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private void processParameters(ListItem parameters) {
        Object value = parameters.getValue();
        StringItem targetItem = (StringItem)value.get(0);
        this.path = targetItem.getValue();
        NumberItem revItem = (NumberItem)value.get(1);
        this.pegRev = revItem.getValue();
        ListItem revisionsListItem = (ListItem)value.get(2);
        Object revisionsList = revisionsListItem.getValue();
        this.revisions = new long[revisionsList.size()];
        int idx = 0;
        Iterator i$ = revisionsList.iterator();
        while (i$.hasNext()) {
            Item item = (Item)i$.next();
            NumberItem numberItem = (NumberItem)item;
            this.revisions[idx++] = numberItem.getValue();
        }
    }
}

