/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.io.File;
import java.util.ArrayList;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.SVNLocationSegment;

public class GetLocationSegmentsCommand
extends AbstractCommand {
    private long endRev;
    private String path;
    private long pegRev;
    private long startRev;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        this.processParameters((ListItem)parameters);
        final ArrayList entries = new ArrayList();
        ISVNLocationSegmentHandler handler = new ISVNLocationSegmentHandler(){

            public void handleLocationSegment(SVNLocationSegment locationSegment) throws SVNException {
                entries.add(locationSegment);
            }
        };
        try {
            context.getRepository().getLocationSegments(this.path, this.pegRev, this.startRev, this.endRev, handler);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            for (SVNLocationSegment entry : entries) {
                ListItem item = new ListItem();
                item.add(entry.getStartRevision());
                item.add(entry.getEndRevision());
                ListItem pathItem = new ListItem();
                if (entry.getPath() == null) continue;
                String entryPath = entry.getPath().equals(File.separator) ? "" : entry.getPath();
                entryPath = entryPath.startsWith(File.separator) ? entryPath.substring(1) : entryPath;
                pathItem.add(entryPath);
                item.add(pathItem);
                SvnMessageEncoding.serialize(context.getOutputStream(), item);
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), new WordItem(Keyword.DONE));
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildEmptySuccess());
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private void processParameters(ListItem parameters) {
        NumberItem item;
        Object value = parameters.getValue();
        StringItem targetItem = (StringItem)value.get(0);
        this.path = targetItem.getValue();
        this.pegRev = -1L;
        ListItem pegRevItem = (ListItem)value.get(1);
        Object pegRevValue = pegRevItem.getValue();
        if (pegRevValue.size() > 0) {
            NumberItem item2 = (NumberItem)pegRevValue.get(0);
            this.pegRev = item2.getValue();
        }
        this.startRev = -1L;
        ListItem revItem = (ListItem)value.get(2);
        Object revValue = revItem.getValue();
        if (revValue.size() > 0) {
            item = (NumberItem)revValue.get(0);
            this.startRev = item.getValue();
        }
        this.endRev = -1L;
        revItem = (ListItem)value.get(3);
        revValue = revItem.getValue();
        if (revValue.size() > 0) {
            item = (NumberItem)revValue.get(0);
            this.endRev = item.getValue();
        }
    }
}

