/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.BytesItem;
import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.ErrorItemBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class GetFileRevCommand
extends AbstractCommand {
    private long endRev;
    private boolean includeMergedRevs;
    private String path;
    private long startRev;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        this.processParameters((ListItem)parameters);
        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
        final ArrayList revisionsList = new ArrayList();
        ISVNFileRevisionHandler handler = new ISVNFileRevisionHandler(){
            private SVNRevision currentRev;

            public void openRevision(SVNFileRevision fileRevision) throws SVNException {
                this.currentRev = new SVNRevision(fileRevision);
            }

            public void closeRevision(String token) throws SVNException {
                revisionsList.add(this.currentRev);
            }

            public void applyTextDelta(String path, String baseChecksum) throws SVNException {
                this.currentRev.setIsModified(true);
            }

            public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
                return null;
            }

            public void textDeltaEnd(String path) throws SVNException {
            }
        };
        try {
            context.getRepository().getFileRevisions(this.path, this.startRev, this.endRev, this.includeMergedRevs, handler);
            SVNRevision preSvnRevision = null;
            for (SVNRevision currentSvnRevision : revisionsList) {
                ListItem fileRev = new ListItem();
                SVNFileRevision svnFileRevision = currentSvnRevision.getSvnFileRevision();
                SVNProperties revisionProperties = svnFileRevision.getRevisionProperties();
                ListItem revPropsList = this.serializeSVNProperties(revisionProperties);
                SVNProperties propertiesDelta = svnFileRevision.getPropertiesDelta();
                ListItem revDeltaPropsList = this.serializeSVNProperties(propertiesDelta);
                fileRev.add(svnFileRevision.getPath());
                fileRev.add(svnFileRevision.getRevision());
                fileRev.add(revPropsList);
                fileRev.add(revDeltaPropsList);
                fileRev.add(new WordItem(Boolean.toString(svnFileRevision.isResultOfMerge())));
                SvnMessageEncoding.serialize(context.getOutputStream(), fileRev);
                final TextDeltaOutputStream out = new TextDeltaOutputStream(context.getOutputStream());
                if (preSvnRevision != null && !currentSvnRevision.isModified()) continue;
                InputStream prevIn = SVNFileUtil.DUMMY_IN;
                if (preSvnRevision != null) {
                    prevIn = SVNKitHelper.getTmpInputStream(context.getRepository(), this.path, preSvnRevision.getSvnFileRevision().getRevision());
                }
                InputStream currentIn = SVNKitHelper.getTmpInputStream(context.getRepository(), this.path, currentSvnRevision.getSvnFileRevision().getRevision());
                SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
                deltaGenerator.sendDelta(this.path, prevIn, 0L, currentIn, new ISVNDeltaConsumer(){

                    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
                    }

                    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
                        try {
                            diffWindow.writeTo(out, true, true);
                        }
                        catch (IOException e) {
                            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_WRITE_ERROR, (Throwable)e));
                        }
                        return null;
                    }

                    public void textDeltaEnd(String path) throws SVNException {
                    }
                }, false);
                SvnMessageEncoding.serialize(context.getOutputStream(), new BytesItem(new byte[0], 0, 0));
                preSvnRevision = currentSvnRevision;
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), new WordItem(Keyword.DONE));
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildEmptySuccess());
        }
        catch (SVNException e) {
            this.sendFailure(context, e);
            throw new ExecutionException(e);
        }
        catch (IOException e) {
            this.sendFailure(context, e);
            throw new ExecutionException(e);
        }
    }

    private void sendFailure(ExecutionContext context, Throwable e) throws MessageEncodingException {
        SvnMessageEncoding.serialize(context.getOutputStream(), new WordItem(Keyword.DONE));
        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(ErrorItemBuilder.buildErrorsList(e)));
    }

    private ListItem serializeSVNProperties(SVNProperties revisionProperties) {
        ListItem revPropsList = new ListItem();
        Set set = revisionProperties.nameSet();
        for (String propName : set) {
            SVNPropertyValue svnPropertyValue = revisionProperties.getSVNPropertyValue(propName);
            String propValue = svnPropertyValue.getString();
            ListItem propertyInfo = new ListItem();
            propertyInfo.add(propName);
            propertyInfo.add(propValue);
            revPropsList.add(propertyInfo);
        }
        return revPropsList;
    }

    private void processParameters(ListItem parameters) {
        NumberItem item;
        Object value = parameters.getValue();
        StringItem targetItem = (StringItem)value.get(0);
        this.path = targetItem.getValue();
        this.startRev = -1L;
        ListItem revItem = (ListItem)value.get(1);
        Object revValue = revItem.getValue();
        if (revValue.size() > 0) {
            item = (NumberItem)revValue.get(0);
            this.startRev = item.getValue();
        }
        this.endRev = -1L;
        revItem = (ListItem)value.get(2);
        revValue = revItem.getValue();
        if (revValue.size() > 0) {
            item = (NumberItem)revValue.get(0);
            this.endRev = item.getValue();
        }
        WordItem includeMergeItem = (WordItem)value.get(3);
        this.includeMergedRevs = Boolean.valueOf(includeMergeItem.getValue());
    }

    private static final class TextDeltaOutputStream
    extends OutputStream {
        private OutputStream out;

        public TextDeltaOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] _bytes, int _offset, int _len) throws IOException {
            try {
                SvnMessageEncoding.serialize(this.out, new BytesItem(_bytes, _len, _offset));
            }
            catch (MessageEncodingException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] _bytes) throws IOException {
            this.write(_bytes, 0, _bytes.length);
        }

        @Override
        public void write(int _byte) throws IOException {
            this.write(new byte[]{(byte)(_byte & 0xFF)});
        }
    }

    private static final class SVNRevision {
        private boolean isModified;
        private SVNFileRevision svnFileRevision;

        public SVNRevision(SVNFileRevision svnFileRevision) {
            this.svnFileRevision = svnFileRevision;
        }

        public SVNFileRevision getSvnFileRevision() {
            return this.svnFileRevision;
        }

        public void setIsModified(boolean modified) {
            this.isModified = modified;
        }

        public boolean isModified() {
            return this.isModified;
        }
    }
}

