/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;

public class GetFileCommand
extends AbstractCommand {
    private String path;
    private long revNumber;
    private boolean wantContents;
    private boolean wantProps;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        this.processParameters((ListItem)parameters);
        SVNProperties props = new SVNProperties();
        OutputStream output = null;
        File file = null;
        try {
            if (this.wantContents) {
                file = File.createTempFile("getFile", ".tmp");
                output = new FileOutputStream(file);
            }
            long rev = context.getRepository().getFile(this.path, this.revNumber, props, output);
            ListItem propList = new ListItem();
            if (this.wantProps) {
                Set set = props.nameSet();
                for (String propName : set) {
                    SVNPropertyValue svnPropertyValue = props.getSVNPropertyValue(propName);
                    ListItem propItem = new ListItem();
                    propItem.add(propName);
                    propItem.add(svnPropertyValue.getString());
                    propList.add(propItem);
                }
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            ListItem dirEntryInfo = new ListItem();
            dirEntryInfo.add(new ListItem());
            dirEntryInfo.add(rev);
            dirEntryInfo.add(propList);
            Item res = SvnMessageBuilder.buildSuccess(dirEntryInfo);
            SvnMessageEncoding.serialize(context.getOutputStream(), res);
            if (this.wantContents && output != null) {
                output.flush();
                output.close();
                FileInputStream in = new FileInputStream(file);
                byte[] buffer = new byte[4096];
                int length = ((InputStream)in).read(buffer);
                while (length >= 0) {
                    SvnMessageEncoding.serialize(context.getOutputStream(), new StringItem(buffer, length, 0));
                    length = ((InputStream)in).read(buffer);
                }
                SvnMessageEncoding.serialize(context.getOutputStream(), new StringItem(""));
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildEmptySuccess());
            }
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
        catch (FileNotFoundException e) {
            throw new ExecutionException(e);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void processParameters(ListItem parameters) {
        Object value = parameters.getValue();
        StringItem targetItem = (StringItem)value.get(0);
        this.path = targetItem.getValue();
        this.revNumber = -1L;
        ListItem revItem = (ListItem)value.get(1);
        Object revValue = revItem.getValue();
        if (revValue.size() > 0) {
            NumberItem item = (NumberItem)revValue.get(0);
            this.revNumber = item.getValue();
        }
        WordItem wantPropItem = (WordItem)value.get(2);
        this.wantProps = Boolean.parseBoolean(wantPropItem.getValue());
        WordItem wantcontentItem = (WordItem)value.get(3);
        this.wantContents = Boolean.parseBoolean(wantcontentItem.getValue());
    }
}

