/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.DirentField;
import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NodeKind;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;

public class GetDirCommand
extends AbstractCommand {
    private List<DirentField> direntsFields = new ArrayList<DirentField>();
    private String path;
    private long revNumber;
    private boolean wantContents;
    private boolean wantProps;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        this.processParameters((ListItem)parameters);
        SVNProperties props = new SVNProperties();
        final HashSet<SVNDirEntry> dirEntries = new HashSet<SVNDirEntry>();
        ISVNDirEntryHandler handler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry _dirEntry) {
                dirEntries.add(_dirEntry);
            }
        };
        try {
            long rev = context.getRepository().getDir(this.path, this.revNumber, props, handler);
            ListItem propList = new ListItem();
            if (this.wantProps) {
                Set set = props.nameSet();
                for (String propName : set) {
                    SVNPropertyValue svnPropertyValue = props.getSVNPropertyValue(propName);
                    ListItem propItem = new ListItem();
                    propItem.add(propName);
                    propItem.add(svnPropertyValue.getString());
                    propList.add(propItem);
                }
            }
            ListItem contentInfo = new ListItem();
            if (this.wantContents) {
                this.processContents(dirEntries, contentInfo);
            }
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            ListItem dirEntryInfo = new ListItem();
            dirEntryInfo.add(rev);
            dirEntryInfo.add(propList);
            dirEntryInfo.add(contentInfo);
            Item res = SvnMessageBuilder.buildSuccess(dirEntryInfo);
            SvnMessageEncoding.serialize(context.getOutputStream(), res);
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }

    private void processContents(Set<SVNDirEntry> dirEntries, ListItem contentInfo) {
        for (SVNDirEntry dirEntry : dirEntries) {
            ListItem dirent = new ListItem();
            String kind = this.direntsFields.contains(DirentField.KIND) ? dirEntry.getKind().toString() : NodeKind.NONE.getCode();
            long size = this.direntsFields.contains(DirentField.SIZE) ? dirEntry.getSize() : 0L;
            boolean hasProps = this.direntsFields.contains(DirentField.HASPROPS);
            long createdRev = this.direntsFields.contains(DirentField.CREATEDREV) ? dirEntry.getRevision() : 0L;
            Date time = this.direntsFields.contains(DirentField.TIME) ? dirEntry.getDate() : null;
            String lastAuthor = this.direntsFields.contains(DirentField.LASTAUTHOR) ? dirEntry.getAuthor() : null;
            dirent.add(dirEntry.getName());
            dirent.add(new WordItem(kind));
            dirent.add(size);
            dirent.add(new WordItem(Boolean.toString(hasProps)));
            dirent.add(createdRev);
            ListItem dateItem = new ListItem();
            dateItem.add(time);
            dirent.add(dateItem);
            ListItem authorItem = new ListItem();
            if (lastAuthor != null) {
                authorItem.add(lastAuthor);
            }
            dirent.add(authorItem);
            contentInfo.add(dirent);
        }
    }

    private void processParameters(ListItem parameters) {
        Object value = parameters.getValue();
        StringItem targetItem = (StringItem)value.get(0);
        this.path = targetItem.getValue();
        this.revNumber = -1L;
        ListItem revItem = (ListItem)value.get(1);
        Object revValue = revItem.getValue();
        if (revValue.size() > 0) {
            NumberItem item = (NumberItem)revValue.get(0);
            this.revNumber = item.getValue();
        }
        WordItem wantPropItem = (WordItem)value.get(2);
        this.wantProps = Boolean.parseBoolean(wantPropItem.getValue());
        WordItem wantcontentItem = (WordItem)value.get(3);
        this.wantContents = Boolean.parseBoolean(wantcontentItem.getValue());
        ListItem dirents = (ListItem)value.get(4);
        Object direntsValue = dirents.getValue();
        Iterator i$ = direntsValue.iterator();
        while (i$.hasNext()) {
            Item item = (Item)i$.next();
            WordItem wordItem = (WordItem)item;
            this.direntsFields.add(DirentField.valueOf(wordItem.getValue().replaceFirst("-", "").toUpperCase()));
        }
    }
}

