/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.exception.MessageEncodingException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class GetDeletedRevCommand
extends AbstractCommand {
    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        ListItem items = (ListItem)parameters;
        Object value = items.getValue();
        StringItem pathItem = (StringItem)value.get(0);
        NumberItem pegRevItem = (NumberItem)value.get(1);
        NumberItem endRevItem = (NumberItem)value.get(2);
        long pegRev = pegRevItem.getValue();
        long endRev = endRevItem.getValue();
        String path = pathItem.getValue();
        SVNRepository repository = context.getRepository();
        try {
            long deletedRevision = repository.getDeletedRevision(path, pegRev, endRev);
            ListItem item = new ListItem();
            item.add(deletedRevision);
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildSuccess(item));
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
    }
}

