/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.io.SVNRepository;

public final class ExecutionContext {
    private InputStream in;
    private OutputStream out;
    private final SVNRepository repository;
    private Stack<Object> stack = new Stack();
    private Stack<String> tokens = new Stack();
    private Map<String, Object> vars = new HashMap<String, Object>();

    public ExecutionContext(InputStream in, OutputStream out, SVNRepository repository) {
        this.in = in;
        this.out = out;
        this.repository = repository;
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void pushToken(String obj) {
        this.tokens.push(obj);
    }

    public String popToken() {
        return this.tokens.empty() ? null : this.tokens.pop();
    }

    public String peekToken() {
        return this.tokens.empty() ? null : this.tokens.peek();
    }

    public void push(Object obj) {
        this.stack.push(obj);
    }

    public Object pop() {
        return this.stack.empty() ? null : this.stack.pop();
    }

    public Object peek() {
        return this.stack.empty() ? null : this.stack.peek();
    }

    public void setVariable(String key, Object value) {
        this.vars.put(key, value);
    }

    public Object getVariable(String key) {
        return this.vars.get(key);
    }

    public void removeVariable(String key) {
        this.vars.remove(key);
    }
}

