/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.subversion.server.command;

import com.oracle.subversion.protocol.Item;
import com.oracle.subversion.protocol.Keyword;
import com.oracle.subversion.protocol.ListItem;
import com.oracle.subversion.protocol.NumberItem;
import com.oracle.subversion.protocol.StringItem;
import com.oracle.subversion.protocol.WordItem;
import com.oracle.subversion.protocol.encoding.ErrorItemBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageBuilder;
import com.oracle.subversion.protocol.encoding.SvnMessageEncoding;
import com.oracle.subversion.server.command.AbstractCommand;
import com.oracle.subversion.server.command.CommandProcessor;
import com.oracle.subversion.server.command.Commands;
import com.oracle.subversion.server.command.Condition;
import com.oracle.subversion.server.command.ExecutionContext;
import com.oracle.subversion.server.command.ExecutionException;
import com.oracle.subversion.server.command.report.ReportCommandHelper;
import com.oracle.subversion.server.exception.MessageEncodingException;
import com.oracle.subversion.server.impl.svnkit.SVNEditorCommandSet;
import com.oracle.subversion.server.impl.svnkit.SVNKitHelper;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DiffCommand
extends AbstractCommand {
    private SVNDepth depth;
    private boolean ingnoreAncestry;
    private boolean recurse;
    private long revNumber;
    private String target;
    private boolean textDeltas;
    private String url;

    @Override
    protected void doExecute(ExecutionContext context, Item parameters) throws ExecutionException, MessageEncodingException {
        this.assertArgumentListType(parameters);
        this.processParameters((ListItem)parameters);
        try {
            SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
            boolean success = ReportCommandHelper.readReportInfo(context);
            if (!success) {
                ListItem errors = new ListItem();
                errors.add(ErrorItemBuilder.buildError(0L, "", 0L, "Report Info processing fail"));
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
            } else {
                SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildNoAuth());
                Object pop = context.pop();
                if (pop == null) {
                    ListItem errors = new ListItem();
                    errors.add(ErrorItemBuilder.buildError(0L, "", 0L, "Failed getting Report Info List"));
                    SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(errors));
                } else {
                    List reportInfos = (List)pop;
                    SVNRepository repository = context.getRepository();
                    SVNEditorCommandSet editor = new SVNEditorCommandSet(repository);
                    SVNURL repositoryRoot = context.getRepository().getRepositoryRoot(false);
                    String targetPath = SVNURL.parseURIDecoded((String)this.url).getPath();
                    SVNURL svnUrl = SVNURL.fromFile((File)new File(repositoryRoot.getPath() + File.separator + targetPath));
                    SVNKitHelper.diff(editor, this.depth, this.revNumber, this.target, this.textDeltas, this.ingnoreAncestry, svnUrl, context.getRepository(), reportInfos);
                    SVNKitHelper.reparent(context.getRepository(), targetPath);
                    editor.processServerSideEditorCommands(context);
                    boolean process = CommandProcessor.process(context.getInputStream(), Commands.MAIN_CMD_SET, context, new Condition(){

                        @Override
                        public boolean finish(Item item) {
                            return item.getValue().equals(Keyword.SUCESS.getCode());
                        }

                        @Override
                        public boolean fail(Item item) {
                            return item.getValue().equals(Keyword.FAILURE.getCode()) || item.getValue().equals(Keyword.ABORT_EDIT.getCode());
                        }
                    });
                    if (process) {
                        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildEmptySuccess());
                    } else {
                        SvnMessageEncoding.serialize(context.getOutputStream(), SvnMessageBuilder.buildFailure(new ListItem()));
                    }
                }
            }
        }
        catch (SVNException e) {
            throw new ExecutionException(e);
        }
        catch (URISyntaxException e) {
            throw new ExecutionException(e);
        }
    }

    private void processParameters(ListItem parameters) {
        Object value = parameters.getValue();
        this.revNumber = -1L;
        ListItem pegRevItem = (ListItem)value.get(0);
        Object pegRevValue = pegRevItem.getValue();
        if (pegRevValue.size() > 0) {
            NumberItem item = (NumberItem)pegRevValue.get(0);
            this.revNumber = item.getValue();
        }
        StringItem targetItem = (StringItem)value.get(1);
        this.target = targetItem.getValue();
        WordItem recurseItem = (WordItem)value.get(2);
        this.recurse = Boolean.parseBoolean(recurseItem.getValue());
        WordItem ingnoreAncestryItem = (WordItem)value.get(3);
        this.ingnoreAncestry = Boolean.parseBoolean(ingnoreAncestryItem.getValue());
        StringItem urlItem = (StringItem)value.get(4);
        this.url = urlItem.getValue();
        WordItem textDeltasItem = (WordItem)value.get(5);
        this.textDeltas = Boolean.parseBoolean(textDeltasItem.getValue());
        WordItem depthItem = (WordItem)value.get(6);
        this.depth = SVNDepth.fromString((String)depthItem.getValue());
    }
}

